/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedexcrafting.recipe.AdvancedPackageRecipeType;
import thelm.packagedexcrafting.recipe.ElitePackageRecipeInfo;

public class ElitePackageRecipeType
implements IPackageRecipeType {
    public static final ElitePackageRecipeType INSTANCE = new ElitePackageRecipeType();
    public static final ResourceLocation NAME = ResourceLocation.parse((String)"packagedexcrafting:elite");
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_DISABLED;

    protected ElitePackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)"recipe.packagedexcrafting.elite");
    }

    public MutableComponent getShortDisplayName() {
        return Component.translatable((String)"recipe.packagedexcrafting.elite.short");
    }

    public MapCodec<? extends IPackageRecipeInfo> getRecipeInfoMapCodec() {
        return ElitePackageRecipeInfo.MAP_CODEC;
    }

    public Codec<? extends IPackageRecipeInfo> getRecipeInfoCodec() {
        return ElitePackageRecipeInfo.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IPackageRecipeInfo> getRecipeInfoStreamCodec() {
        return ElitePackageRecipeInfo.STREAM_CODEC;
    }

    public IPackageRecipeInfo generateRecipeInfoFromStacks(List<ItemStack> inputs, List<ItemStack> outputs, Level level) {
        return new ElitePackageRecipeInfo(inputs, level);
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        int tier;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        Object object = recipeLayoutWrapper.getRecipe();
        if (object instanceof ShapelessTableRecipe) {
            ShapelessTableRecipe shapelessRecipe = (ShapelessTableRecipe)object;
            v0 = shapelessRecipe.getTier();
        } else {
            v0 = tier = 0;
        }
        if (tier == 0 && slotViews.size() == 50 || tier == 3) {
            int index = 0;
            int[] slotArray = SLOTS.toIntArray();
            for (IRecipeSlotViewWrapper slotView : slotViews) {
                if (slotView.isInput()) {
                    ItemStack stack;
                    Object displayed = slotView.getDisplayedIngredient().orElse(null);
                    if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).isEmpty()) {
                        map.put(slotArray[index], (Object)stack);
                    }
                    ++index;
                }
                if (index < 49) continue;
                break;
            }
            return map;
        }
        return AdvancedPackageRecipeType.INSTANCE.getRecipeTransferMap(recipeLayoutWrapper);
    }

    public Object getRepresentation() {
        return new ItemStack((ItemLike)ModBlocks.ELITE_TABLE.get());
    }

    public Vec3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 81) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = List.of(ResourceLocation.parse((String)"extendedcrafting:elite_crafting"), ResourceLocation.parse((String)"extendedcrafting:advanced_crafting"), ResourceLocation.parse((String)"extendedcrafting:basic_crafting"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 1; i < 8; ++i) {
            for (int j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

