/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.unification;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;

public class GregTechModernRecipeUnifier
implements RecipeUnifier {
    private static final String TICK_INPUTS = "tickInputs";
    private static final String TICK_OUTPUTS = "tickOutputs";
    private static final String CONTENT = "content";

    @Override
    public void unify(UnificationHelper helper, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unify(helper, recipe);
        this.doUnify(recipe, "inputs", x$0 -> helper.unifyInputElement((JsonElement)x$0, new String[0]));
        this.doUnify(recipe, TICK_INPUTS, x$0 -> helper.unifyInputElement((JsonElement)x$0, new String[0]));
        this.doUnify(recipe, "outputs", json -> helper.unifyOutputObject((JsonObject)json, true, "item", "ingredient"));
        this.doUnify(recipe, TICK_OUTPUTS, json -> helper.unifyOutputObject((JsonObject)json, true, "item", "ingredient"));
    }

    private void doUnify(RecipeJson recipe, String key, Consumer<JsonObject> callback) {
        JsonElement property = recipe.getProperty(key);
        if (property == null) {
            return;
        }
        JsonElement jsonElement = property.getAsJsonObject().get("item");
        if (!(jsonElement instanceof JsonArray)) {
            return;
        }
        JsonArray arr = (JsonArray)jsonElement;
        for (JsonElement element : arr) {
            JsonElement jsonElement2 = element.getAsJsonObject().get(CONTENT);
            if (!(jsonElement2 instanceof JsonObject)) continue;
            JsonObject content = (JsonObject)jsonElement2;
            callback.accept(content);
        }
    }
}

