/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.TagSubstitutions;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class TagSubstitutionsImpl
implements TagSubstitutions {
    private final Map<TagKey<Item>, TagKey<Item>> replacedToSubstitute;
    private final Multimap<TagKey<Item>, TagKey<Item>> substituteToReplaced;

    private TagSubstitutionsImpl(Map<TagKey<Item>, TagKey<Item>> replacedToSubstitute, Multimap<TagKey<Item>, TagKey<Item>> substituteToReplaced) {
        this.replacedToSubstitute = replacedToSubstitute;
        this.substituteToReplaced = substituteToReplaced;
    }

    public static TagSubstitutionsImpl create(Predicate<TagKey<Item>> validTagFilter, Predicate<TagKey<Item>> unifyTagFilter, Map<ResourceLocation, Set<ResourceLocation>> configuredSubstitutes) {
        ImmutableMap.Builder refsToSubsBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder subsToRefsBuilder = ImmutableMultimap.builder();
        HashSet invalidReplacedTags = new HashSet();
        HashSet unifyReplacedTags = new HashSet();
        configuredSubstitutes.forEach((rawSubstituteTag, rawReplacedTags) -> {
            for (ResourceLocation rawReplacedTag : rawReplacedTags) {
                TagKey substituteTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rawSubstituteTag);
                TagKey replacedTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rawReplacedTag);
                if (!unifyTagFilter.test(substituteTag)) {
                    AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' is not configured as a unify tag! Config entry '#{} -> {}' will be ignored.", (Object)substituteTag.location(), (Object)substituteTag.location(), (Object)rawReplacedTags.stream().map(t -> "#" + String.valueOf(t)).collect(Collectors.joining(", ")));
                    return;
                }
                if (!validTagFilter.test(replacedTag)) {
                    invalidReplacedTags.add(replacedTag);
                    continue;
                }
                if (unifyTagFilter.test(replacedTag)) {
                    unifyReplacedTags.add(replacedTag);
                    continue;
                }
                refsToSubsBuilder.put((Object)replacedTag, (Object)substituteTag);
                subsToRefsBuilder.put((Object)substituteTag, (Object)replacedTag);
            }
            if (!invalidReplacedTags.isEmpty()) {
                AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' contains invalid replaced tags! Affected tags: {}", rawSubstituteTag, (Object)invalidReplacedTags.stream().map(t -> "#" + String.valueOf(t.location())).collect(Collectors.joining(", ")));
            }
            if (!unifyReplacedTags.isEmpty()) {
                AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' contains replaced tags that are configured as unify tags! Affected tags: {}", rawSubstituteTag, (Object)unifyReplacedTags.stream().map(t -> "#" + String.valueOf(t.location())).collect(Collectors.joining(", ")));
            }
        });
        return new TagSubstitutionsImpl((Map<TagKey<Item>, TagKey<Item>>)refsToSubsBuilder.build(), (Multimap<TagKey<Item>, TagKey<Item>>)subsToRefsBuilder.build());
    }

    public void apply(VanillaTagWrapper<Item> itemTags) {
        HashMultimap changedTags = HashMultimap.create();
        this.substituteToReplaced.asMap().forEach((arg_0, arg_1) -> TagSubstitutionsImpl.lambda$apply$5(itemTags, (Multimap)changedTags, arg_0, arg_1));
        changedTags.asMap().forEach((tag, entries) -> AlmostUnifiedCommon.LOGGER.info("[TagSubstitutions] Added items of replaced tags to substitute tag '#{}'. Added items: {}", tag, entries));
    }

    @Override
    @Nullable
    public TagKey<Item> getSubstituteTag(TagKey<Item> replacedTag) {
        return this.replacedToSubstitute.get(replacedTag);
    }

    @Override
    public Collection<TagKey<Item>> getReplacedTags(TagKey<Item> substituteTag) {
        return Collections.unmodifiableCollection(this.substituteToReplaced.get(substituteTag));
    }

    @Override
    public Set<TagKey<Item>> getReplacedTags() {
        return this.replacedToSubstitute.keySet();
    }

    private static /* synthetic */ void lambda$apply$5(VanillaTagWrapper itemTags, Multimap changedTags, TagKey substituteTag, Collection replacedTags) {
        for (TagKey replacedTag : replacedTags) {
            Collection replacedTagHolders = itemTags.get(replacedTag.location());
            for (Holder replacedTagHolder : replacedTagHolders) {
                itemTags.add(substituteTag.location(), replacedTagHolder);
                replacedTagHolder.unwrapKey().ifPresent(key -> changedTags.put((Object)substituteTag.location(), (Object)key.location()));
            }
        }
    }
}

