/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.hooks;

import com.glodblock.github.extendedae.client.gui.GuiTagExportBus;
import com.glodblock.github.extendedae.client.gui.GuiTagStorageBus;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TagHook {
    public static void onInit() {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, evt -> TagHook.hookTooltip(evt.getItemStack(), evt.getToolTip()));
    }

    private static void hookTooltip(ItemStack stack, List<Component> tooltip) {
        if (Minecraft.getInstance().screen instanceof GuiTagExportBus || Minecraft.getInstance().screen instanceof GuiTagStorageBus) {
            if (Screen.hasShiftDown()) {
                IFluidHandlerItem fluidCap;
                Holder holder = stack.getItemHolder();
                boolean anyTag = false;
                if (holder.tags().findAny().isPresent()) {
                    tooltip.add((Component)Component.translatable((String)"tag_display.tooltip.items").withStyle(ChatFormatting.YELLOW));
                    holder.tags().limit(128L).forEach(key -> tooltip.add((Component)Component.literal((String)key.location().toString()).withStyle(ChatFormatting.GREEN)));
                    anyTag = true;
                }
                if ((fluidCap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                    ReferenceOpenHashSet fluidSet = new ReferenceOpenHashSet();
                    for (int tank = 0; tank < fluidCap.getTanks(); ++tank) {
                        FluidStack fluid = fluidCap.getFluidInTank(tank);
                        if (fluid.isEmpty()) continue;
                        fluid.getFluidHolder().tags().forEach(arg_0 -> ((ReferenceSet)fluidSet).add(arg_0));
                    }
                    if (!fluidSet.isEmpty()) {
                        tooltip.add((Component)Component.translatable((String)"tag_display.tooltip.fluids").withStyle(ChatFormatting.YELLOW));
                        fluidSet.stream().limit(128L).forEach(key -> tooltip.add((Component)Component.literal((String)key.location().toString()).withStyle(ChatFormatting.GREEN)));
                        anyTag = true;
                    }
                }
                if (!anyTag) {
                    tooltip.add((Component)Component.translatable((String)"tag_display.tooltip.no_tags").withStyle(ChatFormatting.YELLOW));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"tag_display.tooltip.hint").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

