/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.AECraftingPattern;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.NotNull;

public class CraftingMatrixThread
extends CraftingThread {
    private static final int COOL_TIME = 100;
    private int blockCoolDown = 0;
    private final Supplier<IActionSource> sourceGetter;

    public CraftingMatrixThread(@NotNull AEBaseBlockEntity host, @NotNull Supplier<IActionSource> sourceGetter, CraftingThread.SignalAccepter accepter) {
        super(host, accepter);
        this.sourceGetter = sourceGetter;
    }

    @Override
    protected boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        return !this.gridInv.isEmpty();
    }

    @Override
    protected void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).isEmpty()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.gridInv.getStackInSlot(x);
                if (is.isEmpty()) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, ItemStack.EMPTY);
                this.saveChanges();
                return;
            }
        }
    }

    @Override
    public TickRateModulation tick(int cards, int ticksSinceLastCall) {
        if (this.blockCoolDown > 0) {
            this.blockCoolDown -= ticksSinceLastCall;
            return TickRateModulation.SAME;
        }
        return super.tick(cards, ticksSinceLastCall);
    }

    @Override
    protected ItemStack assemblePattern(CraftingInput input) {
        IMolecularAssemblerSupportedPattern iMolecularAssemblerSupportedPattern = this.myPlan;
        if (iMolecularAssemblerSupportedPattern instanceof AECraftingPattern) {
            AECraftingPattern crafting = (AECraftingPattern)iMolecularAssemblerSupportedPattern;
            CraftingRecipe recipe = (CraftingRecipe)Ae2Reflect.getCraftRecipe(crafting).value();
            if (crafting.canSubstitute && recipe.isSpecial()) {
                return super.assemblePattern(input);
            }
            return Ae2Reflect.getCraftRecipeResult(crafting);
        }
        return super.assemblePattern(input);
    }

    @Override
    protected void pushOut(ItemStack output) {
        if (!(output = this.pushTo(output)).isEmpty()) {
            this.blockCoolDown = 100;
        }
        if (output.isEmpty() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private ItemStack pushTo(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IGrid grid = this.girdHost.getMainNode().getGrid();
        if (grid != null) {
            IStorageService storage = (IStorageService)grid.getService(IStorageService.class);
            long added = storage.getInventory().insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.getCount(), Actionable.MODULATE, this.sourceGetter.get());
            if (added == 0L) {
                return stack;
            }
            this.saveChanges();
            if (added != (long)stack.getCount()) {
                return stack.copyWithCount((int)((long)stack.getCount() - added));
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }
}

