/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.xnet.multiblock.WorldBlob;

public class NetworkChecker {
    private final Set<NetworkId> networks = new HashSet<NetworkId>();
    private long lastHash = -1L;

    public void add(@Nullable NetworkId networkId) {
        if (networkId != null) {
            this.networks.add(networkId);
        }
    }

    public void add(Collection<NetworkId> networks) {
        this.networks.addAll(networks);
    }

    public void add(NetworkChecker checker) {
        this.networks.addAll(checker.networks);
    }

    public void remove(NetworkId networkId) {
        this.networks.remove(networkId);
    }

    private long hash(WorldBlob worldBlob) {
        long h = 0L;
        for (NetworkId network : this.networks) {
            h = Long.rotateLeft(h, 3);
            h ^= (long)worldBlob.getNetworkVersion(network);
        }
        return h;
    }

    public boolean isDirtyAndMarkClean(WorldBlob worldBlob) {
        long h = this.hash(worldBlob);
        if (h != this.lastHash) {
            this.lastHash = h;
            return true;
        }
        return false;
    }

    public void dump() {
        for (NetworkId network : this.networks) {
            System.out.println("network = " + String.valueOf(network));
        }
    }

    public Collection<NetworkId> getAffectedNetworks() {
        return this.networks;
    }
}

