/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.docvalues.FloatDocValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.QueryValueSource;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.mutable.MutableValue;
import guideme.internal.shaded.lucene.util.mutable.MutableValueFloat;
import java.io.IOException;
import java.util.Map;

class QueryDocValues
extends FloatDocValues {
    final LeafReaderContext readerContext;
    final Weight weight;
    final float defVal;
    final Map<Object, Object> fcontext;
    final Query q;
    Scorer scorer;
    DocIdSetIterator disi;
    TwoPhaseIterator tpi;
    Boolean thisDocMatches;
    int lastDocRequested = -1;

    public QueryDocValues(QueryValueSource vs, LeafReaderContext readerContext, Map<Object, Object> fcontext) throws IOException {
        super(vs);
        Weight w;
        this.readerContext = readerContext;
        this.defVal = vs.defVal;
        this.q = vs.q;
        this.fcontext = fcontext;
        Weight weight = w = fcontext == null ? null : (Weight)fcontext.get(vs);
        if (w == null) {
            IndexSearcher weightSearcher;
            if (fcontext == null) {
                weightSearcher = new IndexSearcher(ReaderUtil.getTopLevelContext(readerContext));
            } else {
                weightSearcher = (IndexSearcher)fcontext.get("searcher");
                if (weightSearcher == null) {
                    weightSearcher = new IndexSearcher(ReaderUtil.getTopLevelContext(readerContext));
                }
            }
            vs.createWeight(fcontext, weightSearcher);
            w = (Weight)fcontext.get(vs);
        }
        this.weight = w;
    }

    @Override
    public float floatVal(int doc) {
        try {
            return this.exists(doc) ? this.scorer.score() : this.defVal;
        }
        catch (IOException e) {
            throw new RuntimeException("caught exception in QueryDocVals(" + String.valueOf(this.q) + ") doc=" + doc, e);
        }
    }

    @Override
    public boolean exists(int doc) {
        if (doc < this.lastDocRequested) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocRequested + " vs docID=" + doc);
        }
        this.lastDocRequested = doc;
        try {
            if (this.disi == null) {
                this.scorer = this.weight.scorer(this.readerContext);
                if (this.scorer == null) {
                    this.disi = DocIdSetIterator.empty();
                } else {
                    this.tpi = this.scorer.twoPhaseIterator();
                    this.disi = this.tpi == null ? this.scorer.iterator() : this.tpi.approximation();
                }
                this.thisDocMatches = null;
            }
            if (this.disi.docID() < doc) {
                this.disi.advance(doc);
                this.thisDocMatches = null;
            }
            if (this.disi.docID() == doc) {
                if (this.thisDocMatches == null) {
                    this.thisDocMatches = this.tpi == null || this.tpi.matches();
                }
                return this.thisDocMatches;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("caught exception in QueryDocVals(" + String.valueOf(this.q) + ") doc=" + doc, e);
        }
    }

    @Override
    public Object objectVal(int doc) {
        return Float.valueOf(this.floatVal(doc));
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) {
                try {
                    if (QueryDocValues.this.exists(doc)) {
                        this.mval.value = QueryDocValues.this.scorer.score();
                        this.mval.exists = true;
                    } else {
                        this.mval.value = QueryDocValues.this.defVal;
                        this.mval.exists = false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("caught exception in QueryDocVals(" + String.valueOf(QueryDocValues.this.q) + ") doc=" + doc, e);
                }
            }
        };
    }

    @Override
    public String toString(int doc) {
        return "query(" + String.valueOf(this.q) + ",def=" + this.defVal + ")=" + this.floatVal(doc);
    }
}

