/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchAllDocsQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;
import java.util.Objects;

public class FieldExistsQuery
extends Query {
    private final String field;

    public FieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public static DocIdSetIterator getDocValuesDocIdSetIterator(String field, LeafReader reader) throws IOException {
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
        if (fieldInfo != null) {
            return switch (fieldInfo.getDocValuesType()) {
                case DocValuesType.NONE -> null;
                case DocValuesType.NUMERIC -> reader.getNumericDocValues(field);
                case DocValuesType.BINARY -> reader.getBinaryDocValues(field);
                case DocValuesType.SORTED -> reader.getSortedDocValues(field);
                case DocValuesType.SORTED_NUMERIC -> reader.getSortedNumericDocValues(field);
                case DocValuesType.SORTED_SET -> reader.getSortedSetDocValues(field);
                default -> throw new AssertionError();
            };
        }
        return null;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        return "FieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((FieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        return hash;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        IndexReader reader = indexSearcher.getIndexReader();
        boolean allReadersRewritable = true;
        for (LeafReaderContext context : reader.leaves()) {
            LeafReader leaf = context.reader();
            FieldInfos fieldInfos = leaf.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(this.field);
            if (fieldInfo == null) {
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.hasNorms()) {
                if (reader.getDocCount(this.field) == reader.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getVectorDimension() != 0) {
                if (this.getVectorValuesSize(fieldInfo, leaf) == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                Terms terms = leaf.terms(this.field);
                PointValues pointValues = leaf.getPointValues(this.field);
                if (terms != null && terms.getDocCount() == leaf.maxDoc() || pointValues != null && pointValues.getDocCount() == leaf.maxDoc()) continue;
                allReadersRewritable = false;
                break;
            }
            throw new IllegalStateException(this.buildErrorMsg(fieldInfo));
        }
        if (allReadersRewritable) {
            return new MatchAllDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                DocIdSetIterator iterator;
                block14: {
                    FieldInfo fieldInfo;
                    block16: {
                        block15: {
                            block13: {
                                FieldInfos fieldInfos = context.reader().getFieldInfos();
                                fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                                iterator = null;
                                if (fieldInfo == null) {
                                    return null;
                                }
                                if (!fieldInfo.hasNorms()) break block13;
                                iterator = context.reader().getNormValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            if (fieldInfo.getVectorDimension() == 0) break block15;
                            iterator = switch (fieldInfo.getVectorEncoding()) {
                                default -> throw new MatchException(null, null);
                                case VectorEncoding.FLOAT32 -> context.reader().getFloatVectorValues(FieldExistsQuery.this.field).iterator();
                                case VectorEncoding.BYTE -> context.reader().getByteVectorValues(FieldExistsQuery.this.field).iterator();
                            };
                            break block14;
                        }
                        if (fieldInfo.getDocValuesType() == DocValuesType.NONE) break block16;
                        switch (fieldInfo.getDocValuesType()) {
                            case NUMERIC: {
                                iterator = context.reader().getNumericDocValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            case BINARY: {
                                iterator = context.reader().getBinaryDocValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            case SORTED: {
                                iterator = context.reader().getSortedDocValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            case SORTED_NUMERIC: {
                                iterator = context.reader().getSortedNumericDocValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            case SORTED_SET: {
                                iterator = context.reader().getSortedSetDocValues(FieldExistsQuery.this.field);
                                break block14;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    throw new IllegalStateException(FieldExistsQuery.this.buildErrorMsg(fieldInfo));
                }
                if (iterator == null) {
                    return null;
                }
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public int count(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                FieldInfos fieldInfos = reader.getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                if (fieldInfo == null) {
                    return 0;
                }
                if (fieldInfo.hasNorms()) {
                    if (reader.getDocCount(FieldExistsQuery.this.field) == reader.maxDoc()) {
                        return reader.numDocs();
                    }
                    return super.count(context);
                }
                if (fieldInfo.hasVectorValues()) {
                    if (!reader.hasDeletions()) {
                        return FieldExistsQuery.this.getVectorValuesSize(fieldInfo, reader);
                    }
                    return super.count(context);
                }
                if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    if (!reader.hasDeletions()) {
                        if (fieldInfo.getPointDimensionCount() > 0) {
                            PointValues pointValues = reader.getPointValues(FieldExistsQuery.this.field);
                            return pointValues == null ? 0 : pointValues.getDocCount();
                        }
                        if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                            Terms terms = reader.terms(FieldExistsQuery.this.field);
                            return terms == null ? 0 : terms.getDocCount();
                        }
                    }
                    return super.count(context);
                }
                throw new IllegalStateException(FieldExistsQuery.this.buildErrorMsg(fieldInfo));
            }

            @Override
            public boolean isCacheable(LeafReaderContext context) {
                FieldInfos fieldInfos = context.reader().getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(FieldExistsQuery.this.field);
                if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                    return DocValues.isCacheable(context, FieldExistsQuery.this.field);
                }
                return true;
            }
        };
    }

    private String buildErrorMsg(FieldInfo fieldInfo) {
        return "FieldExistsQuery requires that the field indexes doc values, norms or vectors, but field '" + fieldInfo.name + "' exists and indexes neither of these data structures";
    }

    private int getVectorValuesSize(FieldInfo fi, LeafReader reader) throws IOException {
        assert (fi.name.equals(this.field));
        return switch (fi.getVectorEncoding()) {
            default -> throw new MatchException(null, null);
            case VectorEncoding.FLOAT32 -> {
                FloatVectorValues floatVectorValues = reader.getFloatVectorValues(this.field);
                if (!$assertionsDisabled && floatVectorValues == null) {
                    throw new AssertionError((Object)"unexpected null float vector values");
                }
                yield floatVectorValues.size();
            }
            case VectorEncoding.BYTE -> {
                ByteVectorValues byteVectorValues = reader.getByteVectorValues(this.field);
                if (!$assertionsDisabled && byteVectorValues == null) {
                    throw new AssertionError((Object)"unexpected null byte vector values");
                }
                yield byteVectorValues.size();
            }
        };
    }
}

