/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.impl;

import java.util.UUID;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorConfig;
import mod.azure.azurelib.common.util.client.RenderUtils;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.phys.Vec3;

public abstract class AzEntityAnimator<T extends Entity>
extends AzAnimator<UUID, T> {
    protected AzEntityAnimator() {
    }

    protected AzEntityAnimator(AzAnimatorConfig config) {
        super(config);
    }

    @Override
    protected void applyMolangQueries(T entity, double animTime, float partialTicks) {
        super.applyMolangQueries(entity, animTime, partialTicks);
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft minecraft = Minecraft.getInstance();
        parser.setMemoizedValue(MolangQueries.DISTANCE_FROM_CAMERA, () -> minecraft.gameRenderer.getMainCamera().getPosition().distanceTo(entity.position()));
        parser.setMemoizedValue(MolangQueries.IN_AIR, () -> RenderUtils.booleanToFloat(!entity.onGround()));
        parser.setMemoizedValue(MolangQueries.IS_ON_GROUND, () -> RenderUtils.booleanToFloat(entity.onGround()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER, () -> RenderUtils.booleanToFloat(entity.isInWater()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER_OR_RAIN, () -> RenderUtils.booleanToFloat(entity.isInWaterOrRain()));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            parser.setMemoizedValue(MolangQueries.IS_BLOCKING, () -> RenderUtils.booleanToFloat(livingEntity.isBlocking()));
            parser.setMemoizedValue(MolangQueries.IS_USING_ITEM, () -> RenderUtils.booleanToFloat(livingEntity.isUsingItem()));
            parser.setMemoizedValue(MolangQueries.HEALTH, () -> ((LivingEntity)livingEntity).getHealth());
            parser.setMemoizedValue(MolangQueries.MAX_HEALTH, () -> ((LivingEntity)livingEntity).getMaxHealth());
            parser.setMemoizedValue(MolangQueries.GROUND_SPEED, () -> {
                Vec3 velocity = livingEntity.getDeltaMovement();
                return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
            });
            parser.setMemoizedValue(MolangQueries.YAW_SPEED, () -> livingEntity.getYRot() - livingEntity.yRotO);
            parser.setValue(MolangQueries.HEAD_YAW, () -> livingEntity.getViewYRot(partialTicks) - Mth.lerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot));
            parser.setValue(MolangQueries.HEAD_PITCH, () -> livingEntity.getViewXRot(partialTicks));
            parser.setValue(MolangQueries.HURT_TIME, () -> livingEntity.hurtTime == 0 ? 0.0 : (double)((float)livingEntity.hurtTime - partialTicks));
            parser.setValue(MolangQueries.IS_BABY, () -> RenderUtils.booleanToFloat(livingEntity.isBaby()));
            parser.setValue(MolangQueries.LIMB_SWING, () -> ((WalkAnimationState)livingEntity.walkAnimation).position());
            parser.setValue(MolangQueries.LIMB_SWING_AMOUNT, () -> livingEntity.walkAnimation.speed(partialTicks));
        }
    }
}

