/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.config.format.IConfigFormat;
import mod.azure.azurelib.common.config.value.ConfigValue;
import mod.azure.azurelib.common.config.value.ValueData;
import net.minecraft.network.FriendlyByteBuf;

public final class CharValue
extends ConfigValue<Character> {
    public CharValue(ValueData<Character> valueData) {
        super(valueData);
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeChar(this.getId(), ((Character)this.get()).charValue());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(Character.valueOf(format.readChar(this.getId())));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new CharValue(ValueData.of(name, Character.valueOf(((Character)value).charValue()), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            buffer.writeChar(((Integer)value.get()).intValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, FriendlyByteBuf buffer) {
            return Character.valueOf(buffer.readChar());
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setChar(instance, ((Character)value).charValue());
        }
    }
}

