/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.network.packet;

import java.util.UUID;
import mod.azure.azurelib.common.animation.cache.AzIdentifiableItemStackAnimatorCache;
import mod.azure.azurelib.common.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.common.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.common.animation.impl.AzItemAnimator;
import mod.azure.azurelib.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public record AzItemStackDispatchCommandPacket(UUID itemStackId, AzCommand dispatchCommand) implements AbstractPacket
{
    public static final CustomPacketPayload.Type<AzItemStackDispatchCommandPacket> TYPE = new CustomPacketPayload.Type(AzureLibNetwork.AZ_ITEM_STACK_DISPATCH_COMMAND_SYNC_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, AzItemStackDispatchCommandPacket> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, AzItemStackDispatchCommandPacket::itemStackId, AzCommand.CODEC, AzItemStackDispatchCommandPacket::dispatchCommand, AzItemStackDispatchCommandPacket::new);

    @Override
    public void handle() {
        AzItemAnimator animator = AzIdentifiableItemStackAnimatorCache.getInstance().getOrNull(this.itemStackId);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

