/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import mod.azure.azurelib.common.animation.AzAnimatorAccessor;
import mod.azure.azurelib.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.model.AzBone;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.armor.AzArmorModel;
import mod.azure.azurelib.common.render.armor.AzArmorRenderer;
import mod.azure.azurelib.common.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.common.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.common.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.common.render.armor.compat.ShoulderSurfingCompat;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzArmorRendererPipeline
extends AzRendererPipeline<UUID, ItemStack> {
    private final AzArmorModel<?> armorModel;
    private final AzArmorRenderer armorRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzArmorRendererPipeline(AzRendererConfig<UUID, ItemStack> config, AzArmorRenderer armorRenderer) {
        super(config);
        this.armorModel = new AzArmorModel(this);
        this.armorRenderer = armorRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, ItemStack> createContext(AzRendererPipeline<UUID, ItemStack> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<UUID, ItemStack> createModelRenderer(AzLayerRenderer<UUID, ItemStack> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, ItemStack> createLayerRenderer(AzRendererConfig<UUID, ItemStack> config) {
        return new AzLayerRenderer<UUID, ItemStack>(config::renderLayers);
    }

    @Override
    protected void updateAnimatedTextureFrame(ItemStack animatable) {
        Entity currentEntity = this.context().currentEntity();
        if (currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.config.textureLocation(currentEntity, animatable));
        }
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        AzArmorRendererPipelineContext armorContext = (AzArmorRendererPipelineContext)context;
        HumanoidModel<?> baseModel = armorContext.baseModel();
        AzArmorBoneContext boneContext = armorContext.boneContext();
        AzArmorRendererConfig config = this.config();
        EquipmentSlot currentSlot = armorContext.currentSlot();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        ItemStack animatable = (ItemStack)armorContext.animatable();
        AzBakedModel model = this.armorRenderer.provider().provideBakedModel(this.context().currentEntity(), animatable);
        PoseStack poseStack = armorContext.poseStack();
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.armorModel.applyBaseModel(baseModel);
        boneContext.grabRelevantBones(model, config.boneProvider());
        boneContext.applyBaseTransformations(baseModel);
        this.scaleModelForBaby(armorContext, isReRender);
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        this.scaleBoneWithModelPart(armorContext, boneContext, isReRender);
        if (AzAnimatorAccessor.getOrNull(this.context().currentEntity()) == null) {
            boneContext.applyBoneVisibilityBySlot(currentSlot);
        }
        float alphaValue = config.alpha(context.animatable());
        if (ShoulderSurfingCompat.isLoaded() && ShoulderSurfingCompat.getAlpha(armorContext.currentEntity()) < 1.0f) {
            alphaValue = ShoulderSurfingCompat.getAlpha(armorContext.currentEntity());
        }
        if (alphaValue < 1.0f) {
            int alpha = (int)(alphaValue * 255.0f) << 24;
            int color = armorContext.renderColor() & 0xFFFFFF | alpha;
            armorContext.setRenderColor(color);
            armorContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
        context.setTextureOverride(null);
    }

    public void scaleBoneWithModelPart(AzArmorRendererPipelineContext context, AzArmorBoneContext boneContext, boolean isReRender) {
        HumanoidModel<?> baseModel = context.baseModel();
        EquipmentSlot currentSlot = context.currentSlot();
        if (isReRender) {
            return;
        }
        switch (currentSlot) {
            case HEAD: {
                if (boneContext.head == null) break;
                this.setBoneScale(boneContext.head, baseModel.head);
                break;
            }
            case CHEST: {
                if (boneContext.head != null) {
                    this.setBoneScale(boneContext.leftArm, baseModel.leftArm);
                }
                if (boneContext.rightArm != null) {
                    this.setBoneScale(boneContext.rightArm, baseModel.rightArm);
                }
                if (boneContext.body != null) {
                    this.setBoneScale(boneContext.body, baseModel.body);
                }
                if (boneContext.waist == null) break;
                this.setBoneScale(boneContext.waist, baseModel.body);
                break;
            }
            case FEET: 
            case LEGS: {
                if (boneContext.leftLeg != null) {
                    this.setBoneScale(boneContext.leftLeg, baseModel.leftLeg);
                }
                if (boneContext.rightLeg == null) break;
                this.setBoneScale(boneContext.rightLeg, baseModel.rightLeg);
            }
        }
    }

    private void setBoneScale(AzBone bone, ModelPart modelPart) {
        bone.setScaleX(modelPart.xScale);
        bone.setScaleY(modelPart.yScale);
        bone.setScaleZ(modelPart.zScale);
    }

    public void scaleModelForBaby(AzArmorRendererPipelineContext context, boolean isReRender) {
        AgeableMob ageableMob;
        Entity currentEntity = context.currentEntity();
        if (!(currentEntity instanceof AgeableMob) || !(ageableMob = (AgeableMob)currentEntity).isBaby() || isReRender) {
            return;
        }
        HumanoidModel<?> baseModel = context.baseModel();
        EquipmentSlot currentSlot = context.currentSlot();
        PoseStack poseStack = context.poseStack();
        if (currentSlot == EquipmentSlot.HEAD) {
            if (baseModel.scaleHead) {
                float headScale = 1.5f / baseModel.babyHeadScale;
                poseStack.scale(headScale, headScale, headScale);
            }
            poseStack.translate(0.0f, baseModel.babyYHeadOffset / 16.0f, baseModel.babyZHeadOffset / 16.0f);
        } else {
            float bodyScale = 1.0f / baseModel.babyBodyScale;
            poseStack.scale(bodyScale, bodyScale, bodyScale);
            poseStack.translate(0.0f, baseModel.bodyYOffset / 16.0f, 0.0f);
        }
    }

    public AzArmorModel armorModel() {
        return this.armorModel;
    }

    public AzArmorRendererConfig config() {
        return (AzArmorRendererConfig)super.config();
    }

    public AzArmorRendererPipelineContext context() {
        return (AzArmorRendererPipelineContext)super.context();
    }

    public AzArmorRenderer renderer() {
        return this.armorRenderer;
    }
}

