/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.entity;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class AzEntityNameRenderUtil {
    public static <T extends Entity> boolean shouldShowName(EntityRenderDispatcher entityRenderDispatcher, T entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.isDiscrete() ? 32.0 : 64.0;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entityRenderDispatcher.distanceToSqr(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        if (!(!(entity instanceof Mob) || entity.shouldShowName() || entity.hasCustomName() && entity == entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = Objects.requireNonNull(minecraft.player);
        boolean visibleToClient = !entity.isInvisibleTo((Player)player);
        PlayerTeam entityTeam = entity.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && entity != minecraft.getCameraEntity() && visibleToClient && !entity.isVehicle();
        }
        PlayerTeam playerTeam = minecraft.player.getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    private AzEntityNameRenderUtil() {
        throw new UnsupportedOperationException();
    }
}

