/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import mod.azure.azurelib.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import mod.azure.azurelib.common.render.entity.AzEntityLayerRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityLeashRenderUtil;
import mod.azure.azurelib.common.render.entity.AzEntityRenderer;
import mod.azure.azurelib.common.render.entity.AzEntityRendererConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzEntityRendererPipeline<T extends Entity>
extends AzRendererPipeline<UUID, T> {
    private final AzEntityRenderer<T> entityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzEntityRendererPipeline(AzEntityRendererConfig<T> config, AzEntityRenderer<T> entityRenderer) {
        super(config);
        this.entityRenderer = entityRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, T> createContext(AzRendererPipeline<UUID, T> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<UUID, T> createModelRenderer(AzLayerRenderer<UUID, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, T> createLayerRenderer(AzRendererConfig<UUID, T> config) {
        return new AzEntityLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.last().pose());
        AzEntityRendererConfig<Object> config = this.entityRenderer.config();
        float scaleWidth = config.scaleWidth((Entity)context.animatable());
        float scaleHeight = config.scaleHeight((Entity)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (config.alpha((Entity)context.animatable()) < 1.0f || ((Entity)context.animatable()).isInvisible()) {
            double setAlpha = ((Entity)context.animatable()).isInvisible() ? (((Entity)context.animatable()).isInvisibleTo((Player)Minecraft.getInstance().player) ? 0.0 : 0.38) : (double)config.alpha((Entity)context.animatable());
            int alpha = (int)(setAlpha * 255.0) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
        context.setTextureOverride(null);
    }

    @Override
    public void renderFinal(AzRendererPipelineContext<UUID, T> context) {
        MultiBufferSource bufferSource = context.multiBufferSource();
        Entity entity = (Entity)context.animatable();
        int packedLight = context.packedLight();
        float partialTick = context.partialTick();
        PoseStack poseStack = context.poseStack();
        this.entityRenderer.superRender(entity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Entity leashHolder = mob.getLeashHolder();
        if (leashHolder == null) {
            return;
        }
        AzEntityLeashRenderUtil.renderLeash(this.entityRenderer, mob, partialTick, poseStack, bufferSource, leashHolder);
    }

    @Override
    protected void doPostRenderCleanup(AzRendererPipelineContext<UUID, T> context) {
        context.setCurrentEntity(null);
    }

    public AzEntityRenderer<T> getRenderer() {
        return this.entityRenderer;
    }
}

