/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.xnet.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.RSMode;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public abstract class AbstractConnectorSettings
implements IConnectorSettings {
    public static final String TAG_RS = "rs";
    public static final String TAG_COLOR = "color";
    public static final String TAG_FACING = "facing";
    public static final BaseSettings DEFAULT_SETTINGS = new BaseSettings(RSMode.IGNORED, Color.OFF, Color.OFF, Color.OFF, Color.OFF, null);
    protected BaseSettings settings;
    private int colorsMask = 0;
    private int prevPulse = 0;
    protected boolean advanced = false;
    @Nonnull
    private final Direction side;

    public AbstractConnectorSettings(@Nonnull BaseSettings base, @Nonnull Direction side) {
        this.settings = base;
        this.side = side;
        this.calculateColorsMask();
    }

    @Nonnull
    public Direction getSide() {
        return this.side;
    }

    @Nonnull
    public Direction getFacing() {
        return this.settings.facingOverride == null ? this.side : this.settings.facingOverride;
    }

    public RSMode getRsMode() {
        return this.settings.rsMode;
    }

    public int getPrevPulse() {
        return this.prevPulse;
    }

    public void setPrevPulse(int prevPulse) {
        this.prevPulse = prevPulse;
    }

    private void calculateColorsMask() {
        this.colorsMask = 0;
        if (this.settings.color0 != Color.OFF) {
            this.colorsMask |= 1 << this.settings.color0.ordinal();
        }
        if (this.settings.color1 != Color.OFF) {
            this.colorsMask |= 1 << this.settings.color1.ordinal();
        }
        if (this.settings.color2 != Color.OFF) {
            this.colorsMask |= 1 << this.settings.color2.ordinal();
        }
        if (this.settings.color3 != Color.OFF) {
            this.colorsMask |= 1 << this.settings.color3.ordinal();
        }
    }

    public int getColorsMask() {
        return this.colorsMask;
    }

    @Override
    public void update(Map<String, Object> data) {
        RSMode rsMode = data.containsKey(TAG_RS) ? RSMode.valueOf(((String)data.get(TAG_RS)).toUpperCase()) : RSMode.IGNORED;
        Color colors0 = data.containsKey("color0") ? Color.colorByValue((Integer)data.get("color0")) : Color.OFF;
        Color colors1 = data.containsKey("color1") ? Color.colorByValue((Integer)data.get("color1")) : Color.OFF;
        Color colors2 = data.containsKey("color2") ? Color.colorByValue((Integer)data.get("color2")) : Color.OFF;
        Color colors3 = data.containsKey("color3") ? Color.colorByValue((Integer)data.get("color3")) : Color.OFF;
        String facing = (String)data.get(TAG_FACING);
        Direction facingOverride = facing == null ? null : Direction.byName((String)facing.toLowerCase());
        this.settings = new BaseSettings(rsMode, colors0, colors1, colors2, colors3, facingOverride);
        this.calculateColorsMask();
    }

    protected static <T extends Enum<T>> void setEnumSafe(JsonObject object, String tag, T value) {
        if (value != null) {
            object.add(tag, (JsonElement)new JsonPrimitive(value.name()));
        }
    }

    protected static <T extends Enum<T>> T getEnumSafe(JsonObject object, String tag, Function<String, T> translator) {
        if (object.has(tag)) {
            return (T)((Enum)translator.apply(object.get(tag).getAsString()));
        }
        return null;
    }

    protected static void setIntegerSafe(JsonObject object, String tag, Integer value) {
        if (value != null) {
            object.add(tag, (JsonElement)new JsonPrimitive((Number)value));
        }
    }

    protected static Integer getIntegerSafe(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsInt();
        }
        return null;
    }

    protected static int getIntegerNotNull(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsInt();
        }
        return 0;
    }

    protected static boolean getBoolSafe(JsonObject object, String tag) {
        if (object.has(tag)) {
            return object.get(tag).getAsBoolean();
        }
        return false;
    }

    protected void writeToJsonInternal(JsonObject object) {
        AbstractConnectorSettings.setEnumSafe(object, "rsmode", this.settings.rsMode);
        AbstractConnectorSettings.setEnumSafe(object, "color0", this.settings.color0);
        AbstractConnectorSettings.setEnumSafe(object, "color1", this.settings.color1);
        AbstractConnectorSettings.setEnumSafe(object, "color2", this.settings.color2);
        AbstractConnectorSettings.setEnumSafe(object, "color3", this.settings.color3);
        AbstractConnectorSettings.setEnumSafe(object, "side", this.side);
        AbstractConnectorSettings.setEnumSafe(object, "facingoverride", this.settings.facingOverride);
        object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
    }

    protected void readFromJsonInternal(JsonObject object) {
        RSMode rsMode = AbstractConnectorSettings.getEnumSafe(object, "rsmode", BaseStringTranslators::getRSMode);
        Color color0 = AbstractConnectorSettings.getEnumSafe(object, "color0", BaseStringTranslators::getColor);
        Color color1 = AbstractConnectorSettings.getEnumSafe(object, "color1", BaseStringTranslators::getColor);
        Color color2 = AbstractConnectorSettings.getEnumSafe(object, "color2", BaseStringTranslators::getColor);
        Color color3 = AbstractConnectorSettings.getEnumSafe(object, "color3", BaseStringTranslators::getColor);
        Direction facingOverride = AbstractConnectorSettings.getEnumSafe(object, "facingoverride", s -> Direction.byName((String)s.toLowerCase()));
        this.settings = new BaseSettings(rsMode, color0, color1, color2, color3, facingOverride);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.prevPulse = tag.getInt("prevPulse");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.putInt("prevPulse", this.prevPulse);
    }

    protected IEditorGui sideGui(IEditorGui gui) {
        return gui.choices(TAG_FACING, "Side from which to operate", (Enum)(this.settings.facingOverride == null ? this.side : this.settings.facingOverride), (Enum[])OrientationTools.DIRECTION_VALUES);
    }

    protected IEditorGui colorsGui(IEditorGui gui) {
        return gui.colors("color0", "Enable on color", this.settings.color0.getColor(), Color.COLORS).colors("color1", "Enable on color", this.settings.color1.getColor(), Color.COLORS).colors("color2", "Enable on color", this.settings.color2.getColor(), Color.COLORS).colors("color3", "Enable on color", this.settings.color3.getColor(), Color.COLORS);
    }

    protected IEditorGui redstoneGui(IEditorGui gui) {
        return gui.redstoneMode(TAG_RS, this.settings.rsMode);
    }

    public record BaseSettings(RSMode rsMode, Color color0, Color color1, Color color2, Color color3, Direction facingOverride) {
        public static final Codec<BaseSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RSMode.CODEC.fieldOf("rsMode").forGetter(BaseSettings::rsMode), (App)Color.CODEC.fieldOf("color0").forGetter(BaseSettings::color0), (App)Color.CODEC.fieldOf("color1").forGetter(BaseSettings::color1), (App)Color.CODEC.fieldOf("color2").forGetter(BaseSettings::color2), (App)Color.CODEC.fieldOf("color3").forGetter(BaseSettings::color3), (App)Direction.CODEC.optionalFieldOf("facingOverride").forGetter(s -> Optional.ofNullable(s.facingOverride()))).apply((Applicative)instance, (rsMode, c0, c1, c2, c3, direction) -> new BaseSettings((RSMode)((Object)((Object)rsMode)), (Color)((Object)((Object)c0)), (Color)((Object)((Object)c1)), (Color)((Object)((Object)c2)), (Color)((Object)((Object)c3)), direction.orElse(null))));
        public static final StreamCodec<FriendlyByteBuf, BaseSettings> STREAM_CODEC = StreamCodec.composite(RSMode.STREAM_CODEC, BaseSettings::rsMode, Color.STREAM_CODEC, BaseSettings::color0, Color.STREAM_CODEC, BaseSettings::color1, Color.STREAM_CODEC, BaseSettings::color2, Color.STREAM_CODEC, BaseSettings::color3, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Direction.STREAM_CODEC), s -> Optional.ofNullable(s.facingOverride()), (rsMode, c0, c1, c2, c3, direction) -> new BaseSettings((RSMode)((Object)rsMode), (Color)((Object)c0), (Color)((Object)c1), (Color)((Object)c2), (Color)((Object)c3), direction.orElse(null)));
    }
}

