/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stal111.forbidden_arcanus.client.model.DarkTraderModel;
import com.stal111.forbidden_arcanus.client.model.QuantumLightDoorModel;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTrader;
import com.stal111.forbidden_arcanus.common.entity.darktrader.DarkTraderVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;

public class DarkTraderRenderer
extends MobRenderer<DarkTrader, DarkTraderModel> {
    private final QuantumLightDoorModel<DarkTrader> portalModel;

    public DarkTraderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DarkTraderModel(context.bakeLayer(DarkTraderModel.LAYER_LOCATION)), 0.5f);
        this.portalModel = new QuantumLightDoorModel(context);
    }

    public void render(@NotNull DarkTrader entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        if (entity.getPose() != Pose.EMERGING || entity.spawnAnimationState.isStarted()) {
            super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
        if (entity.portalAnimationState.isStarted()) {
            this.portalModel.render(entity, poseStack, buffer, packedLight, (float)entity.tickCount + partialTicks);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull DarkTrader entity) {
        return ((DarkTraderVariant)entity.getVariant().value()).texture();
    }
}

