/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.CarvedEdelwoodLogBlock;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;

public class EdelwoodLogBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty OILY = ModBlockStateProperties.OILY;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final EnumMap<Direction.Axis, VoxelShape> SHAPES = VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST));
    private static final float RAIN_FILL_CHANCE = 0.15f;
    private static final float OILY_CHANCE = 0.025f;

    public EdelwoodLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        if (this.getStateDefinition().getProperties().contains(AXIS)) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)OILY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return context.isHoldingItem(((EdelwoodLogBlock)((Object)ModBlocks.EDELWOOD_LOG.get())).asItem()) || context.isHoldingItem(((CarvedEdelwoodLogBlock)((Object)ModBlocks.CARVED_EDELWOOD_LOG.get())).asItem()) ? Shapes.block() : SHAPES.get(state.getValue(AXIS));
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getClickedFace().getAxis())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    public void randomTick(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (random.nextDouble() < (double)0.025f && level.isAreaLoaded(pos, 4)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OILY, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.randomTick(state, level, pos, random);
    }

    public boolean isRandomlyTicking(@Nonnull BlockState state) {
        return (Boolean)state.getValue((Property)OILY) == false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.is(Items.GLASS_BOTTLE) && ((Boolean)state.getValue((Property)OILY)).booleanValue()) {
            ItemStack oil = new ItemStack((ItemLike)ModItems.EDELWOOD_OIL.get());
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
            if (stack.isEmpty()) {
                player.setItemInHand(hand, oil);
            } else if (!player.getInventory().add(oil)) {
                player.drop(oil, false);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OILY, (Comparable)Boolean.valueOf(false)));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (stack.canPerformAction(ItemAbilities.AXE_STRIP) && !this.isCarved() && state.getValue(AXIS) == Direction.Axis.Y) {
            Direction direction = result.getDirection().getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : result.getDirection();
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (!level.isClientSide()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((CarvedEdelwoodLogBlock)((Object)ModBlocks.CARVED_EDELWOOD_LOG.get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)OILY, (Comparable)((Boolean)state.getValue((Property)OILY)))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    protected boolean shouldHandlePrecipitation(BlockState state, Level level, Biome.Precipitation precipitation) {
        if (!(((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || state.hasProperty(AXIS) && state.getValue(AXIS) != Direction.Axis.Y || precipitation != Biome.Precipitation.RAIN)) {
            return level.getRandom().nextFloat() < 0.15f;
        }
        return false;
    }

    public void handlePrecipitation(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Biome.Precipitation precipitation) {
        if (this.shouldHandlePrecipitation(state, level, precipitation)) {
            int i = 0;
            BlockState belowState = level.getBlockState(pos.below(i + 1));
            while (!(!belowState.is(ModTags.Blocks.EDELWOOD_LOGS) || belowState.hasProperty(AXIS) && belowState.getValue(AXIS) != Direction.Axis.Y || ((Boolean)belowState.getValue((Property)WATERLOGGED)).booleanValue())) {
                belowState = level.getBlockState(pos.below(++i + 1));
            }
            level.setBlockAndUpdate(pos.below(i), (BlockState)level.getBlockState(pos.below(i)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos.below(i));
        }
    }

    @Nonnull
    public BlockState rotate(BlockState state, @Nonnull Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, OILY, WATERLOGGED});
    }

    protected boolean isCarved() {
        return false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

