/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.core.config.ItemConfig;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BoomArrow
extends AbstractArrow {
    public BoomArrow(EntityType<? extends BoomArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BoomArrow(Level level, LivingEntity shooter, ItemStack pickupStack, @Nullable ItemStack stack) {
        super((EntityType)ModEntities.BOOM_ARROW.get(), shooter, level, pickupStack, stack);
    }

    public BoomArrow(Level level, double x, double y, double z, ItemStack pickupStack, @Nullable ItemStack stack) {
        super((EntityType)ModEntities.BOOM_ARROW.get(), x, y, z, level, pickupStack, stack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.inGround) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.BOOM_ARROW.get());
    }

    protected void doPostHurtEffects(@Nonnull LivingEntity entity) {
        super.doPostHurtEffects(entity);
        this.level().explode((Entity)this, entity.getX(), entity.getY(), entity.getZ(), (float)((Integer)ItemConfig.BOOM_ARROW_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ItemConfig.BOOM_ARROW_BLOCK_DAMAGE.get() != false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
    }
}

