/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DracoArcanusArrow
extends AbstractArrow {
    public DracoArcanusArrow(EntityType<? extends DracoArcanusArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DracoArcanusArrow(Level level, LivingEntity shooter, ItemStack pickupStack, @Nullable ItemStack stack) {
        super((EntityType)ModEntities.DRACO_ARCANUS_ARROW.get(), shooter, level, pickupStack, stack);
    }

    public DracoArcanusArrow(Level level, double x, double y, double z, ItemStack pickupStack, @Nullable ItemStack stack) {
        super((EntityType)ModEntities.DRACO_ARCANUS_ARROW.get(), x, y, z, level, pickupStack, stack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.inGround) {
            this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.DRACO_ARCANUS_ARROW.get());
    }

    protected void doPostHurtEffects(@Nonnull LivingEntity entity) {
        super.doPostHurtEffects(entity);
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity2 = this.getOwner();
        if (entity2 instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity2;
            areaEffectCloud.setOwner(owner);
        }
        areaEffectCloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
        areaEffectCloud.setRadius(2.0f);
        areaEffectCloud.setDuration(400);
        areaEffectCloud.setRadiusPerTick((7.0f - areaEffectCloud.getRadius()) / (float)areaEffectCloud.getDuration());
        areaEffectCloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
        this.level().levelEvent(2006, this.blockPosition(), 0);
        this.level().addFreshEntity((Entity)areaEffectCloud);
    }
}

