/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.integration.ForbiddenArcanusJEIPlugin;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import java.util.HashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ClibanoCombustionCategory
implements IRecipeCategory<ClibanoRecipe> {
    private static final ResourceLocation TEXTURE = ForbiddenArcanus.location("textures/gui/jei/clibano_combustion.png");
    private static final Component TITLE = Component.translatable((String)"jei.forbidden_arcanus.category.clibanoCombustion");
    private static final int WIDTH = 147;
    private static final int HEIGHT = 97;
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableStatic staticBlueFlame;
    protected final IDrawableStatic staticPurpleFlame;
    private final HashMap<ClibanoFireType, IDrawableAnimated> animatedFlames = new HashMap();
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public ClibanoCombustionCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 147, 97);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CLIBANO_CORE.get()));
        this.staticFlame = guiHelper.createDrawable(TEXTURE, 151, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.FIRE, guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.staticBlueFlame = guiHelper.createDrawable(TEXTURE, 170, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.SOUL_FIRE, guiHelper.createAnimatedDrawable(this.staticBlueFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.staticPurpleFlame = guiHelper.createDrawable(TEXTURE, 189, 1, 12, 15);
        this.animatedFlames.put(ClibanoFireType.ENCHANTED_FIRE, guiHelper.createAnimatedDrawable(this.staticPurpleFlame, 300, IDrawableAnimated.StartDirection.TOP, true));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            @NotNull
            public IDrawableAnimated load(@NotNull Integer cookTime) {
                return guiHelper.drawableBuilder(TEXTURE, 148, 32, 13, 12).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    @NotNull
    public RecipeType<ClibanoRecipe> getRecipeType() {
        return ForbiddenArcanusJEIPlugin.CLIBANO_COMBUSTION;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ClibanoRecipe recipe, @NotNull IFocusGroup focuses) {
        TagKey<Item> tagKey;
        builder.addSlot(RecipeIngredientRole.INPUT, 37, 24).addIngredients((Ingredient)recipe.getIngredients().get(0));
        if (recipe.isDoubleRecipe()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 55, 24).addIngredients((Ingredient)recipe.getIngredients().get(1));
        }
        if ((tagKey = recipe.requiredFireType().getTagKey()) != null) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 12, 60).addIngredients(Ingredient.of(tagKey));
        }
        recipe.requiredEnhancer().ifPresent(enhancer -> builder.addSlot(RecipeIngredientRole.CATALYST, 12, 24).addItemStack(((Item)((EnhancerDefinition)enhancer.value()).displayItem().value()).getDefaultInstance()));
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 35).addItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess));
    }

    private IDrawableAnimated getArrow(int cookingTime) {
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookingTime);
    }

    public void draw(@NotNull ClibanoRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.animatedFlames.get((Object)recipe.requiredFireType()).draw(guiGraphics, 48, 43);
        if (!recipe.isDoubleRecipe()) {
            guiGraphics.blit(TEXTURE, 54, 23, 224, 0, 18, 18);
        }
        IDrawableAnimated arrow = this.getArrow(recipe.getDefaultCookingTime());
        arrow.draw(guiGraphics, 74, 43);
        this.drawExperience(recipe.experience(), guiGraphics, 12);
        this.drawCookTime(recipe.getDefaultCookingTime(), guiGraphics, 79);
    }

    protected void drawExperience(float experience, GuiGraphics guiGraphics, int y) {
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)experienceString);
            guiGraphics.drawString(font, (Component)experienceString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(int cookingTime, GuiGraphics guiGraphics, int y) {
        if (cookingTime > 0) {
            int cookTimeSeconds = cookingTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            guiGraphics.drawString(font, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull ClibanoRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 92.0 && mouseY >= 59.0 && mouseX <= 117.0 && mouseY <= 65.0) {
            recipe.residueChance().ifPresent(chance -> tooltip.add((FormattedText)((ResidueType)chance.type().value()).name().copy().append(" ").append((Component)Component.translatable((String)"jei.forbidden_arcanus.clibanoCombustion.residue")).append(" (" + chance.chance() * 100.0 + "%)")));
        }
    }

    public int getWidth() {
        return 147;
    }

    public int getHeight() {
        return 97;
    }
}

