/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.entity.projectile.EnergyBall;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DracoArcanusScepterItem
extends Item {
    private static final int USE_DURATION = 30;
    private static final int COOLDOWN_TICKS = 10;

    public DracoArcanusScepterItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!level.isClientSide()) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ENERGY_BALL_LAUNCH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                EnergyBall energyBall = new EnergyBall(level, (LivingEntity)player, player.getLookAngle().x * 1.0, player.getLookAngle().y * 1.0, player.getLookAngle().z * 1.0);
                energyBall.setPos(energyBall.getX(), player.getY() + (double)player.getEyeHeight(), energyBall.getZ());
                level.addFreshEntity((Entity)energyBall);
            }
            player.getCooldowns().addCooldown((Item)this, 10);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(@Nonnull ItemStack stack, LivingEntity entity) {
        return 30;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return false;
    }
}

