/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.mundabitur;

import com.stal111.forbidden_arcanus.common.item.mundabitur.EntityInteraction;
import com.stal111.forbidden_arcanus.common.item.mundabitur.MundabiturInteraction;
import com.stal111.forbidden_arcanus.common.item.mundabitur.TransformPatternInteraction;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MundabiturDustItem
extends Item {
    public MundabiturDustItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        TransformPatternInteraction.TransformPatternContext transformContext = TransformPatternInteraction.TransformPatternContext.of(level, context.getClickedPos(), context.getHand(), context.getClickedFace());
        return this.tryInteract(player, stack, TransformPatternInteraction.class, transformContext);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        EntityInteraction.EntityInteractionContext context = EntityInteraction.EntityInteractionContext.of(target, hand);
        return this.tryInteract(player, stack, EntityInteraction.class, context);
    }

    private <T extends MundabiturInteraction.Context> InteractionResult tryInteract(Player player, ItemStack stack, Class<? extends MundabiturInteraction<T>> clazz, T context) {
        Optional<MundabiturInteraction> optional = FARegistries.MUNDABITUR_INTERACTION_REGISTRY.stream().filter(clazz::isInstance).map(clazz::cast).filter(interaction -> interaction.canInteract(context)).findFirst();
        if (optional.isPresent()) {
            Level level = player.level();
            optional.get().interact(context);
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, context.getPos(), (SoundEvent)ModSounds.MUNDABITUR_DUST_USE.get(), SoundSource.PLAYERS, 1.0f, level.getRandom().nextFloat() * 0.15f + 0.9f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

