/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.enhancer;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerTarget;
import com.stal111.forbidden_arcanus.common.item.enhancer.condition.EffectCondition;
import com.stal111.forbidden_arcanus.common.item.enhancer.condition.TimeCondition;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.ConditionalEnhancerEffect;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.EnhancerEffect;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.MultiplyRequiredEssenceEffect;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.MultiplySoulDurationEffect;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryHelper;

public class ModEnhancerDefinitions
extends DatapackRegistryClass<EnhancerDefinition> {
    public static final DatapackRegistryHelper<EnhancerDefinition> HELPER = (DatapackRegistryHelper)ForbiddenArcanus.REGISTRY_MANAGER.getHelper(FARegistries.ENHANCER_DEFINITION);
    public static final ResourceKey<EnhancerDefinition> ARTISAN_RELIC = HELPER.createKey("artisan_relic");
    public static final ResourceKey<EnhancerDefinition> CRESCENT_MOON = HELPER.createKey("crescent_moon");
    public static final ResourceKey<EnhancerDefinition> CRIMSON_STONE = HELPER.createKey("crimson_stone");
    public static final ResourceKey<EnhancerDefinition> SOUL_CRIMSON_STONE = HELPER.createKey("soul_crimson_stone");
    public static final ResourceKey<EnhancerDefinition> ELEMENTARIUM = HELPER.createKey("elementarium");
    public static final ResourceKey<EnhancerDefinition> DIVINE_PACT = HELPER.createKey("divine_pact");
    public static final ResourceKey<EnhancerDefinition> MALEDICTUS_PACT = HELPER.createKey("maledictus_pact");

    public ModEnhancerDefinitions(BootstrapContext<EnhancerDefinition> context) {
        super(context);
    }

    public void bootstrap(BootstrapContext<EnhancerDefinition> context) {
        context.register(ARTISAN_RELIC, (Object)EnhancerDefinition.create(this.generateDescription("artisan_relic", EnhancerTarget.HEPHAESTUS_FORGE, EnhancerTarget.CLIBANO), (Item)ModItems.ARTISAN_RELIC.get(), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.EXPERIENCE, 0.75))));
        context.register(CRESCENT_MOON, (Object)EnhancerDefinition.create(this.generateDescription("crescent_moon", EnhancerTarget.HEPHAESTUS_FORGE), (Item)ModItems.CRESCENT_MOON.get(), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.AUREAL, 0.9), new TimeCondition(23000, 23999)), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.AUREAL, 0.9), new TimeCondition(0, 12999)), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.AUREAL, 0.99), new TimeCondition(13000, 22999))));
        context.register(CRIMSON_STONE, (Object)EnhancerDefinition.create(this.generateDescription("crimson_stone", EnhancerTarget.HEPHAESTUS_FORGE, EnhancerTarget.CLIBANO), (Item)ModItems.CRIMSON_STONE.get(), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.SOULS, 0.5)), this.effect(new MultiplySoulDurationEffect(1.3))));
        context.register(SOUL_CRIMSON_STONE, (Object)EnhancerDefinition.create(this.generateDescription("soul_crimson_stone", EnhancerTarget.HEPHAESTUS_FORGE), (Item)ModItems.SOUL_CRIMSON_STONE.get(), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.AUREAL, 0.0)), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.SOULS, 0.0)), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.BLOOD, 0.0)), this.effect(new MultiplyRequiredEssenceEffect(EssenceType.EXPERIENCE, 0.0))));
        context.register(ELEMENTARIUM, (Object)EnhancerDefinition.create(this.generateDescription("elementarium", EnhancerTarget.HEPHAESTUS_FORGE), (Item)ModItems.ELEMENTARIUM.get(), new ConditionalEnhancerEffect[0]));
        context.register(DIVINE_PACT, (Object)EnhancerDefinition.create(this.generateDescription("divine_pact", EnhancerTarget.HEPHAESTUS_FORGE), (Item)ModItems.DIVINE_PACT.get(), new ConditionalEnhancerEffect[0]));
        context.register(MALEDICTUS_PACT, (Object)EnhancerDefinition.create(this.generateDescription("maledictus_pact", EnhancerTarget.HEPHAESTUS_FORGE), (Item)ModItems.MALEDICTUS_PACT.get(), new ConditionalEnhancerEffect[0]));
    }

    private Map<EnhancerTarget, Component> generateDescription(String key, EnhancerTarget ... targets) {
        return Arrays.stream(targets).collect(Collectors.toMap(Function.identity(), enhancerTarget -> Component.translatable((String)("item.forbidden_arcanus.enhancer." + key + "." + enhancerTarget.getSerializedName()))));
    }

    private <T extends EnhancerEffect> ConditionalEnhancerEffect<T> effect(T effect) {
        return ConditionalEnhancerEffect.of(effect);
    }

    private <T extends EnhancerEffect> ConditionalEnhancerEffect<T> effect(T effect, EffectCondition condition) {
        return ConditionalEnhancerEffect.of(effect, List.of(condition));
    }
}

