/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.recipes;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueChance;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.stal111.forbidden_arcanus.data.enhancer.ModEnhancerDefinitions;
import com.stal111.forbidden_arcanus.data.recipes.builder.ClibanoRecipeBuilder;
import com.stal111.forbidden_arcanus.data.residue.ModResidueTypes;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.valhelsia.valhelsia_core.datagen.recipes.RecipeSubProvider;
import net.valhelsia.valhelsia_core.datagen.recipes.ValhelsiaRecipeProvider;

public class ClibanoRecipeProvider
extends RecipeSubProvider {
    public static final double CHANCE_65 = 0.65;
    public static final double CHANCE_33 = 0.33;
    public static final double CHANCE_20 = 0.2;
    public static final double CHANCE_10 = 0.1;
    public static final double CHANCE_05 = 0.05;

    public ClibanoRecipeProvider(ValhelsiaRecipeProvider provider) {
        super(provider);
    }

    protected void registerRecipes(HolderLookup.Provider lookupProvider) {
        HolderLookup.RegistryLookup residueLookup = lookupProvider.lookupOrThrow(FARegistries.RESIDUE_TYPE);
        HolderLookup.RegistryLookup enhancerLookup = lookupProvider.lookupOrThrow(FARegistries.ENHANCER_DEFINITION);
        this.add(this.clibanoRecipe((ItemLike)ModItems.ARCANE_CRYSTAL.get(), Ingredient.of(ModTags.Items.ARCANE_CRYSTAL_ORES), 1.0f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.ARCANE_CRYSTAL), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has(ModTags.Items.ARCANE_CRYSTAL_ORES)));
        this.add(this.clibanoRecipe((ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()}), 0.4f, 80).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.ARCANE_CRYSTAL), 0.1)).unlockedBy("has_item", ClibanoRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()})));
        this.add(this.clibanoRecipe((ItemLike)ModItems.RUNE.get(), Ingredient.of(ModTags.Items.RUNIC_STONES), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.RUNE), 0.1)).unlockedBy("has_item", ClibanoRecipeProvider.has(ModTags.Items.RUNIC_STONES)));
        this.add(this.clibanoRecipe((ItemLike)Items.COAL, Ingredient.of((TagKey)ItemTags.COAL_ORES), 0.05f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.COAL), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.COAL_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.IRON_INGOT, Ingredient.of((TagKey)ItemTags.IRON_ORES), 0.35f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.IRON), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.IRON_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.GOLD_INGOT, Ingredient.of((TagKey)ItemTags.GOLD_ORES), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.GOLD), 0.2)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.GOLD_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.COPPER_INGOT, Ingredient.of((TagKey)ItemTags.COPPER_ORES), 0.35f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.COPPER), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.COPPER_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.LAPIS_LAZULI, Ingredient.of((TagKey)ItemTags.LAPIS_ORES), 0.1f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.LAPIS_LAZULI), 0.2)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.LAPIS_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.DIAMOND, Ingredient.of((TagKey)ItemTags.DIAMOND_ORES), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.DIAMOND), 0.1)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.DIAMOND_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.EMERALD, Ingredient.of((TagKey)ItemTags.EMERALD_ORES), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.EMERALD), 0.1)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)ItemTags.EMERALD_ORES)));
        this.add(this.clibanoRecipe((ItemLike)Items.NETHERITE_SCRAP, Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ANCIENT_DEBRIS}), 1.0f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.NETHERITE), 0.05)).unlockedBy("has_item", ClibanoRecipeProvider.has((ItemLike[])new ItemLike[]{Blocks.ANCIENT_DEBRIS})));
        this.add(this.clibanoRecipe((ItemLike)Items.IRON_INGOT, Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_IRON), 0.35f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.IRON), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)Tags.Items.RAW_MATERIALS_IRON)), "clibano_combustion/iron_ingot_from_clibano_combusting_raw_iron");
        this.add(this.clibanoRecipe((ItemLike)Items.GOLD_INGOT, Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_GOLD), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.GOLD), 0.2)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)Tags.Items.RAW_MATERIALS_GOLD)), "clibano_combustion/gold_ingot_from_clibano_combusting_raw_gold");
        this.add(this.clibanoRecipe((ItemLike)Items.COPPER_INGOT, Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_COPPER), 0.35f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.COPPER), 0.33)).unlockedBy("has_item", ClibanoRecipeProvider.has((TagKey)Tags.Items.RAW_MATERIALS_COPPER)), "clibano_combustion/copper_ingot_from_clibano_combusting_raw_copper");
        Holder.Reference artisanRelic = enhancerLookup.getOrThrow(ModEnhancerDefinitions.ARTISAN_RELIC);
        this.add(this.clibanoRecipe((ItemLike)ModItems.OBSIDIANSTEEL_INGOT.get(), Ingredient.of((TagKey)Tags.Items.RAW_MATERIALS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OBSIDIAN}), 0.5f, 100).residue(new ResidueChance((Holder<ResidueType>)residueLookup.getOrThrow(ModResidueTypes.COPPER), 0.33)).enhancer((Holder<EnhancerDefinition>)artisanRelic).unlockedBy("has_raw_iron", ClibanoRecipeProvider.has((TagKey)Tags.Items.RAW_MATERIALS_IRON)).unlockedBy("has_obsidian", ClibanoRecipeProvider.has((ItemLike[])new ItemLike[]{Blocks.OBSIDIAN})));
    }

    public void add(RecipeBuilder builder) {
        super.add(builder, "clibano_combustion/" + BuiltInRegistries.ITEM.getKey((Object)builder.getResult()).getPath() + "_from_clibano_combustion");
    }

    private ClibanoRecipeBuilder clibanoRecipe(ItemLike result, Ingredient ingredient, float experience, int cookingTime) {
        return new ClibanoRecipeBuilder(RecipeCategory.MISC, CookingBookCategory.MISC, result.asItem().getDefaultInstance(), (Either<Ingredient, Pair<Ingredient, Ingredient>>)Either.left((Object)ingredient), experience, cookingTime);
    }

    private ClibanoRecipeBuilder clibanoRecipe(ItemLike result, Ingredient firstIngredient, Ingredient secondIngredient, float experience, int cookingTime) {
        return new ClibanoRecipeBuilder(RecipeCategory.MISC, CookingBookCategory.MISC, result.asItem().getDefaultInstance(), (Either<Ingredient, Pair<Ingredient, Ingredient>>)Either.right((Object)Pair.of((Object)firstIngredient, (Object)secondIngredient)), experience, cookingTime);
    }
}

