/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.compat.jei;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.client.screen.AwakeningAltarnatorScreen;
import com.blakebr0.mysticalautomation.client.screen.CrafterScreen;
import com.blakebr0.mysticalautomation.client.screen.EnchanternatorScreen;
import com.blakebr0.mysticalautomation.client.screen.FarmerScreen;
import com.blakebr0.mysticalautomation.client.screen.InfusionAltarnatorScreen;
import com.blakebr0.mysticalautomation.compat.jei.GhostIngredientHandler;
import com.blakebr0.mysticalautomation.compat.jei.category.FarmerCategory;
import com.blakebr0.mysticalautomation.compat.jei.category.FertilizerCategory;
import com.blakebr0.mysticalautomation.compat.jei.recipe.FertilizerFakeRecipe;
import com.blakebr0.mysticalautomation.init.ModBlocks;
import com.blakebr0.mysticalautomation.init.ModRecipeTypes;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    private static final RecipeType<IEnchanterRecipe> ENCHANTER_RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"enchanter", IEnchanterRecipe.class);
    private static final RecipeType<IInfusionRecipe> INFUSION_ALTARNATOR_RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"infusion", IInfusionRecipe.class);
    private static final RecipeType<IAwakeningRecipe> AWAKENING_ALTARNATOR_RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"awakening", IAwakeningRecipe.class);
    public static final ResourceLocation UID = MysticalAutomation.resource("jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FarmerCategory(guiHelper), new FertilizerCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CRAFTER.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FARMER.get()), new RecipeType[]{FarmerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FERTILIZER.get()), new RecipeType[]{FertilizerCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENCHANTERNATOR.get()), new RecipeType[]{ENCHANTER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFUSION_ALTARNATOR.get()), new RecipeType[]{INFUSION_ALTARNATOR_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AWAKENING_ALTARNATOR.get()), new RecipeType[]{AWAKENING_ALTARNATOR_RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            RecipeManager manager = level.getRecipeManager();
            registration.addRecipes(FarmerCategory.RECIPE_TYPE, RecipeHelper.byTypeValues((RecipeManager)manager, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FARMER.get())));
        }
        registration.addRecipes(FertilizerCategory.RECIPE_TYPE, FertilizerFakeRecipe.createAll());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CrafterScreen.class, 114, 48, 24, 16, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(FarmerScreen.class, 85, 52, 24, 16, new RecipeType[]{FarmerCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(EnchanternatorScreen.class, 143, 47, 24, 16, new RecipeType[]{ENCHANTER_RECIPE_TYPE});
        registration.addRecipeClickArea(InfusionAltarnatorScreen.class, 133, 49, 24, 16, new RecipeType[]{INFUSION_ALTARNATOR_RECIPE_TYPE});
        registration.addRecipeClickArea(AwakeningAltarnatorScreen.class, 133, 49, 24, 16, new RecipeType[]{AWAKENING_ALTARNATOR_RECIPE_TYPE});
        registration.addGhostIngredientHandler(CrafterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(EnchanternatorScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(InfusionAltarnatorScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(AwakeningAltarnatorScreen.class, new GhostIngredientHandler());
    }
}

