/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.crafting;

import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.api.crafting.IFarmerRecipe;
import com.blakebr0.mysticalautomation.compat.MysticalCompat;
import com.blakebr0.mysticalautomation.config.ModConfigs;
import com.blakebr0.mysticalautomation.crafting.recipe.FarmerRecipe;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;

public final class DynamicRecipeManager {
    public static final DynamicRecipeManager INSTANCE = new DynamicRecipeManager();

    @SubscribeEvent
    public void onRecipeManagerLoading(RecipeManagerLoadingEvent event) {
        if (((Boolean)ModConfigs.FARMER_DYNAMIC_MYSTICAL_AGRICULTURE_RECIPES.get()).booleanValue()) {
            for (Crop crop : MysticalAgricultureAPI.getCropRegistry().getCrops()) {
                if (!crop.isEnabled() || "inferium".equals(crop.getName())) continue;
                ResourceLocation id = MysticalAutomation.resource("farmer/mysticalagriculture/" + crop.getNameWithSuffix("seeds"));
                FarmerRecipe recipe = DynamicRecipeManager.createResourceSeedRecipe(crop);
                if (recipe == null) continue;
                event.addRecipe(new RecipeHolder(id, (Recipe)recipe));
            }
        }
    }

    private static FarmerRecipe createResourceSeedRecipe(Crop crop) {
        ItemNameBlockItem seeds = crop.getSeedsItem();
        if (seeds == null) {
            return null;
        }
        Block farmland = crop.getTier().getFarmland();
        if (farmland == null) {
            return null;
        }
        Item essence = crop.getEssenceItem();
        if (essence == null) {
            return null;
        }
        Ingredient crux = crop.getCruxBlock() != null ? Ingredient.of((ItemLike[])new ItemLike[]{crop.getCruxBlock()}) : Ingredient.EMPTY;
        int stages = crop.getCropBlock() != null ? crop.getCropBlock().getMaxAge() : 7;
        float fertilizedEssenceChance = (float)MysticalAgricultureAPI.getConfigValues().getFertilizedEssenceDropChance();
        List<IFarmerRecipe.FarmerResult> results = List.of(new IFarmerRecipe.FarmerResult(new ItemStack((ItemLike)crop.getEssenceItem()), 1.0f), new IFarmerRecipe.FarmerResult(new ItemStack(MysticalCompat.Items.FERTILIZED_ESSENCE), fertilizedEssenceChance));
        return new FarmerRecipe(Ingredient.of((ItemLike[])new ItemLike[]{seeds}), Ingredient.of((ItemLike[])new ItemLike[]{farmland}), crux, stages, results);
    }
}

