/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.network.payload;

import com.blakebr0.mysticalautomation.MysticalAutomation;
import com.blakebr0.mysticalautomation.tileentity.EnchanternatorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EnchanternatorSelectLevelPayload(BlockPos pos, int level) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EnchanternatorSelectLevelPayload> TYPE = new CustomPacketPayload.Type(MysticalAutomation.resource("enchanternator_select_level"));
    public static final StreamCodec<FriendlyByteBuf, EnchanternatorSelectLevelPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, EnchanternatorSelectLevelPayload::pos, (StreamCodec)ByteBufCodecs.VAR_INT, EnchanternatorSelectLevelPayload::level, EnchanternatorSelectLevelPayload::new);

    public CustomPacketPayload.Type<EnchanternatorSelectLevelPayload> type() {
        return TYPE;
    }

    public static void handleServer(EnchanternatorSelectLevelPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(payload.pos);
            if (tile instanceof EnchanternatorTileEntity) {
                EnchanternatorTileEntity machine = (EnchanternatorTileEntity)tile;
                int selectedLevel = machine.getSelectedLevel();
                if (selectedLevel == payload.level) {
                    machine.setSelectedLevel(0);
                } else {
                    machine.setSelectedLevel(payload.level);
                }
            }
        });
    }
}

