/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.equipment.armor.BacktankBlock;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.blueprint.BlueprintEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.JadeAddonsBase;
import snownee.jade.addon.create.BacktankProvider;
import snownee.jade.addon.create.BlazeBurnerProvider;
import snownee.jade.addon.create.ContraptionExactBlockProvider;
import snownee.jade.addon.create.ContraptionFluidStorageProvider;
import snownee.jade.addon.create.ContraptionItemStorageProvider;
import snownee.jade.addon.create.CraftingBlueprintProvider;
import snownee.jade.addon.create.FilterProvider;
import snownee.jade.addon.create.GogglesProvider;
import snownee.jade.addon.create.HideBoilerHandlerProvider;
import snownee.jade.addon.create.PackageProvider;
import snownee.jade.addon.create.PlacardProvider;
import snownee.jade.addon.create.TableClothProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.CommonProxy;

public class CreatePlugin
implements IWailaPlugin {
    public static final String ID = "jadeaddons.create";
    public static final ResourceLocation CRAFTING_BLUEPRINT = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"crafting_blueprint");
    public static final ResourceLocation PLACARD = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"placard");
    public static final ResourceLocation BLAZE_BURNER = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"blaze_burner");
    public static final ResourceLocation CONTRAPTION_INVENTORY = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"contraption_inv");
    public static final ResourceLocation CONTRAPTION_EXACT_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"exact_block");
    public static final ResourceLocation FILTER = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"filter");
    public static final ResourceLocation HIDE_BOILER_TANKS = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"hide_boiler_tanks");
    public static final ResourceLocation BACKTANK_CAPACITY = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"backtank_capacity");
    public static final ResourceLocation GOGGLES = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"goggles");
    public static final ResourceLocation REQUIRES_GOGGLES = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"goggles.requires_goggles");
    public static final ResourceLocation GOGGLES_DETAILED = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"goggles.detailed");
    public static final ResourceLocation PACKAGE = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"package");
    public static final ResourceLocation TABLE_CLOTH = ResourceLocation.fromNamespaceAndPath((String)"jadeaddons.create", (String)"table_cloth");

    public void register(IWailaCommonRegistration registration) {
        registration.registerBlockDataProvider((IServerDataProvider)BlazeBurnerProvider.INSTANCE, BlazeBurnerBlockEntity.class);
        registration.registerBlockDataProvider((IServerDataProvider)BacktankProvider.INSTANCE, BacktankBlockEntity.class);
        registration.registerItemStorage((IServerExtensionProvider)ContraptionItemStorageProvider.INSTANCE, AbstractContraptionEntity.class);
        registration.registerItemStorage((IServerExtensionProvider)PackageProvider.INSTANCE, PackageEntity.class);
        registration.registerItemStorage((IServerExtensionProvider)TableClothProvider.INSTANCE, TableClothBlockEntity.class);
        registration.registerFluidStorage((IServerExtensionProvider)ContraptionFluidStorageProvider.INSTANCE, AbstractContraptionEntity.class);
        registration.registerFluidStorage((IServerExtensionProvider)HideBoilerHandlerProvider.INSTANCE, FluidTankBlockEntity.class);
        if (CommonProxy.isPhysicallyClient()) {
            registration.registerItemStorage((IServerExtensionProvider)CraftingBlueprintProvider.INSTANCE, BlueprintEntity.class);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(REQUIRES_GOGGLES, true);
        registration.addConfig(GOGGLES_DETAILED, false);
        registration.registerEntityComponent((IComponentProvider)CraftingBlueprintProvider.INSTANCE, BlueprintEntity.class);
        registration.registerBlockComponent((IComponentProvider)PlacardProvider.INSTANCE, PlacardBlock.class);
        registration.registerBlockIcon((IComponentProvider)PlacardProvider.INSTANCE, PlacardBlock.class);
        registration.registerBlockComponent((IComponentProvider)BlazeBurnerProvider.INSTANCE, BlazeBurnerBlock.class);
        registration.registerEntityIcon((IComponentProvider)ContraptionExactBlockProvider.INSTANCE, AbstractContraptionEntity.class);
        registration.registerEntityComponent((IComponentProvider)ContraptionExactBlockProvider.INSTANCE, AbstractContraptionEntity.class);
        registration.registerBlockComponent((IComponentProvider)FilterProvider.INSTANCE, Block.class);
        registration.registerBlockComponent((IComponentProvider)BacktankProvider.INSTANCE, BacktankBlock.class);
        registration.registerBlockComponent((IComponentProvider)new GogglesProvider(), Block.class);
        registration.registerItemStorageClient((IClientExtensionProvider)ContraptionItemStorageProvider.INSTANCE);
        registration.registerItemStorageClient((IClientExtensionProvider)CraftingBlueprintProvider.INSTANCE);
        registration.registerItemStorageClient((IClientExtensionProvider)PackageProvider.INSTANCE);
        registration.registerItemStorageClient((IClientExtensionProvider)TableClothProvider.INSTANCE);
        registration.registerFluidStorageClient((IClientExtensionProvider)ContraptionFluidStorageProvider.INSTANCE);
        registration.registerFluidStorageClient((IClientExtensionProvider)HideBoilerHandlerProvider.INSTANCE);
        EntityType.byString((String)"create:super_glue").ifPresent(arg_0 -> ((IWailaClientRegistration)registration).hideTarget(arg_0));
        RayTracing.ENTITY_FILTER = RayTracing.ENTITY_FILTER.and(e -> {
            Contraption contraption;
            Vec3 localTarget;
            if (!(e instanceof AbstractContraptionEntity)) {
                return true;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)e;
            Minecraft mc = Minecraft.getInstance();
            Entity camera = mc.getCameraEntity();
            if (camera == null) {
                return true;
            }
            Vec3 origin = camera.getEyePosition(mc.getTimer().getGameTimeDeltaTicks());
            Vec3 lookVector = camera.getViewVector(mc.getTimer().getGameTimeDeltaTicks());
            double reach = mc.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE).getValue() + (double)IWailaConfig.get().getGeneral().getExtendedReach();
            Vec3 target = origin.add(lookVector.x * reach, lookVector.y * reach, lookVector.z * reach);
            Vec3 localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
            RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil((Vec3)localOrigin, (Vec3)(localTarget = contraptionEntity.toLocalVector(target, 1.0f)), arg_0 -> CreatePlugin.lambda$registerClient$0(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, contraptionEntity, arg_0));
            return predicateResult != null && !predicateResult.missed();
        });
        registration.addRayTraceCallback(this::override);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Accessor<?> override(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return accessor;
        }
        if (originalAccessor instanceof EntityAccessor) {
            return accessor;
        }
        BlockHitResult trackHit = new BlockHitResult(Vec3.atCenterOf((Vec3i)result.blockEntity().getBlockPos()), Direction.UP, result.blockEntity().getBlockPos(), false);
        return JadeAddonsBase.client.blockAccessor().blockState(result.blockEntity().getBlockState()).blockEntity((BlockEntity)result.blockEntity()).hit(trackHit).build();
    }

    private static /* synthetic */ boolean lambda$registerClient$0(Contraption contraption, Vec3 localOrigin, Vec3 localTarget, AbstractContraptionEntity contraptionEntity, BlockPos p) {
        StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(p);
        if (blockInfo == null) {
            return false;
        }
        BlockState state = blockInfo.state();
        VoxelShape raytraceShape = state.getShape((BlockGetter)Minecraft.getInstance().level, BlockPos.ZERO);
        if (raytraceShape.isEmpty()) {
            return false;
        }
        BlockHitResult rayTrace = raytraceShape.clip(localOrigin, localTarget, p);
        if (IWailaConfig.get().getPlugin().get(CONTRAPTION_EXACT_BLOCK) && rayTrace != null && rayTrace.getType() != HitResult.Type.MISS) {
            BlockAccessor originalAccessor;
            BlockAccessor accessor = originalAccessor = JadeAddonsBase.client.blockAccessor().blockState(state).hit(rayTrace).build();
            for (JadeRayTraceCallback callback : WailaClientRegistration.instance().rayTraceCallback.callbacks()) {
                accessor = callback.onRayTrace((HitResult)rayTrace, (Accessor)accessor, (Accessor)originalAccessor);
            }
            if (accessor != null) {
                ContraptionExactBlockProvider.INSTANCE.setHit((Entity)contraptionEntity, (Accessor<?>)accessor);
            }
        }
        return rayTrace != null;
    }
}

