/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.lib.gui.CircularPointedArrayList;
import com.davenonymous.bonsaitrees.lib.gui.WidgetSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class WidgetContainer
extends AbstractContainerMenu {
    public static ResourceLocation SLOTGROUP_PLAYER = BonsaiTrees.resource("player_slots");
    private final IItemHandler playerInventory;
    private final CircularPointedArrayList<ResourceLocation> slotGroups;
    private final Map<ResourceLocation, List<Integer>> slotGroupMap;
    private final Map<ResourceLocation, List<ResourceLocation>> allowedSlotGroupQuickMoving;
    private int nextSlotId = 0;

    protected WidgetContainer(@Nullable MenuType<?> type, int id, Inventory inv) {
        super(type, id);
        this.playerInventory = new InvWrapper((Container)inv);
        this.slotGroups = new CircularPointedArrayList();
        this.slotGroupMap = new HashMap<ResourceLocation, List<Integer>>();
        this.allowedSlotGroupQuickMoving = new HashMap<ResourceLocation, List<ResourceLocation>>();
    }

    protected Slot addSlot(Slot slotIn) {
        if (!(slotIn instanceof WidgetSlot)) {
            throw new RuntimeException("Only WidgetSlots are allowed in a WidgetContainer!");
        }
        ResourceLocation slotGroupId = ((WidgetSlot)slotIn).getGroupId();
        if (!this.slotGroups.contains(slotGroupId)) {
            this.slotGroups.add(slotGroupId);
        }
        if (!this.slotGroupMap.containsKey(slotGroupId)) {
            this.slotGroupMap.put(slotGroupId, new ArrayList());
        }
        this.slotGroupMap.get(slotGroupId).add(this.nextSlotId++);
        return super.addSlot(slotIn);
    }

    public List<WidgetSlot> getSlotsForGroup(ResourceLocation groupId) {
        ArrayList<WidgetSlot> result = new ArrayList<WidgetSlot>();
        if (this.slotGroupMap.containsKey(groupId)) {
            for (int slotIndex : this.slotGroupMap.get(groupId)) {
                result.add((WidgetSlot)((Object)this.slots.get(slotIndex)));
            }
        }
        return result;
    }

    protected void allowSlotGroupMovement(ResourceLocation from, ResourceLocation to, boolean bidirectional) {
        this.allowSlotGroupMovement(from, to);
        if (bidirectional) {
            this.allowSlotGroupMovement(to, from);
        }
    }

    protected void allowSlotGroupMovement(ResourceLocation from, ResourceLocation to) {
        if (!this.allowedSlotGroupQuickMoving.containsKey(from)) {
            this.allowedSlotGroupQuickMoving.put(from, new ArrayList());
        }
        this.allowedSlotGroupQuickMoving.get(from).add(to);
    }

    protected void lockSlot(int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot instanceof WidgetSlot) {
            ((WidgetSlot)slot).setLocked(true);
            this.slots.set(index, (Object)slot);
        }
    }

    protected int addSlotRange(ResourceLocation id, IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new WidgetSlot(id, handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(ResourceLocation id, IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(id, handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(SLOTGROUP_PLAYER, this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(SLOTGROUP_PLAYER, this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private ArrayList<Integer> getTransferTargetSlots(WidgetSlot pSlot) {
        ItemStack stack = pSlot.getItem();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int groupIndex = 0; groupIndex < this.slotGroups.size(); ++groupIndex) {
            List<ResourceLocation> allowedGroups;
            ResourceLocation targetGroup = this.slotGroups.next();
            if (this.allowedSlotGroupQuickMoving.containsKey(pSlot.getGroupId()) && (allowedGroups = this.allowedSlotGroupQuickMoving.get(pSlot.getGroupId())).size() > 0 && !allowedGroups.contains(targetGroup)) continue;
            List<Integer> slotsForThisGroup = this.slotGroupMap.get(targetGroup);
            for (int slotIndex : slotsForThisGroup) {
                ItemStack existingStack;
                WidgetSlot testSlot = (WidgetSlot)((Object)this.slots.get(slotIndex));
                if (!testSlot.isEnabled() || testSlot.isLocked() || !testSlot.mayPlace(stack) || testSlot.hasItem() && (!stack.isStackable() || !(existingStack = testSlot.getItem()).isStackable() || !existingStack.is(stack.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize() || existingStack.getCount() >= testSlot.getMaxStackSize() || existingStack.getCount() >= testSlot.getMaxStackSize(existingStack))) continue;
                result.add(slotIndex);
            }
        }
        return result;
    }

    private int getSlotStackLimit(WidgetSlot slot, ItemStack stack) {
        int limit = Integer.MAX_VALUE;
        limit = Math.min(limit, slot.getMaxStackSize(stack));
        limit = Math.min(limit, slot.getMaxStackSize());
        limit = Math.min(limit, stack.getMaxStackSize());
        return limit;
    }

    private ItemStack insertStackIntoSlot(WidgetSlot slot, ItemStack stack) {
        ItemStack existingStack = slot.getItem();
        int fitSize = this.getSlotStackLimit(slot, stack);
        int remainingSpace = fitSize - existingStack.getCount();
        int toAddSize = stack.getCount();
        int remaining = Math.max(0, toAddSize - remainingSpace);
        int inserted = toAddSize - remaining;
        ItemStack toInsert = stack.copy();
        toInsert.setCount(inserted + existingStack.getCount());
        slot.set(toInsert);
        ItemStack remainingStack = stack.copy();
        remainingStack.setCount(remaining);
        return remainingStack;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        WidgetSlot targetSlot;
        int targetSlotId;
        Slot uncastSlot = (Slot)this.slots.get(index);
        if (uncastSlot == null || !uncastSlot.hasItem() || !(uncastSlot instanceof WidgetSlot)) {
            return ItemStack.EMPTY;
        }
        WidgetSlot slot = (WidgetSlot)uncastSlot;
        ItemStack stackToMove = uncastSlot.getItem().copy();
        if (stackToMove.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.slotGroups.setPointerTo(slot.getGroupId());
        ArrayList<Integer> availableSlotsInOrderOfPriority = this.getTransferTargetSlots(slot);
        Iterator iterator = availableSlotsInOrderOfPriority.iterator();
        while (iterator.hasNext() && ((targetSlotId = ((Integer)iterator.next()).intValue()) == index || !(stackToMove = this.insertStackIntoSlot(targetSlot = (WidgetSlot)((Object)this.slots.get(targetSlotId)), stackToMove)).isEmpty())) {
        }
        slot.set(stackToMove);
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }
}

