/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.gui.tooltip;

import com.davenonymous.bonsaitrees.lib.gui.tooltip.BoxAlignment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class HBoxTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final List<TooltipComponent> components = new ArrayList<TooltipComponent>();
    private int padding = 2;
    private BoxAlignment alignment = BoxAlignment.START;

    public HBoxTooltipComponent(TooltipComponent ... components) {
        this.components.addAll(Arrays.asList(components));
    }

    public HBoxTooltipComponent add(TooltipComponent ... component) {
        this.components.addAll(Arrays.asList(component));
        return this;
    }

    public HBoxTooltipComponent setAlignment(BoxAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public HBoxTooltipComponent setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int count() {
        return this.components.size();
    }

    public HBoxTooltipComponent clear() {
        this.components.clear();
        return this;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int currentX = x;
        int maxHeight = this.getHeight();
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            int yOffset = y;
            int componentHeight = clientComponent.getHeight();
            if (this.alignment == BoxAlignment.CENTER) {
                yOffset += (maxHeight - componentHeight) / 2;
            } else if (this.alignment == BoxAlignment.END) {
                yOffset += maxHeight - componentHeight;
            }
            clientComponent.renderImage(font, currentX, yOffset, guiGraphics);
            currentX += clientComponent.getWidth(font) + this.padding;
        }
    }

    public int getHeight() {
        int max = 0;
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            max = Math.max(max, clientComponent.getHeight());
        }
        return max;
    }

    public int getWidth(Font font) {
        int sum = 0;
        for (TooltipComponent component : this.components) {
            if (!(component instanceof ClientTooltipComponent)) continue;
            ClientTooltipComponent clientComponent = (ClientTooltipComponent)component;
            sum += clientComponent.getWidth(font) + this.padding;
        }
        return sum;
    }
}

