/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.lib.recipe;

import com.davenonymous.bonsaitrees.setup.ModRecipes;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TransformItemRecipe
extends CustomRecipe {
    Ingredient input;
    ItemStack output;

    public TransformItemRecipe(CraftingBookCategory category, Ingredient input, ItemStack output) {
        super(category);
        this.input = input;
        this.output = output;
    }

    public Ingredient input() {
        return this.input;
    }

    public ItemStack output() {
        return this.output;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.size() != 1) {
            return false;
        }
        ItemStack stack = (ItemStack)craftingInput.items().getFirst();
        if (stack.isEmpty()) {
            return false;
        }
        return this.input().test(stack);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack stack = (ItemStack)craftingInput.items().getFirst();
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = ItemStack.EMPTY;
        if (this.input().test(stack)) {
            result = this.output().copy();
        }
        List<DataComponentType> copyableComponentList = stack.getComponents().stream().map(TypedDataComponent::type).toList();
        result.copyFrom((DataComponentHolder)stack, copyableComponentList.toArray(new DataComponentType[0]));
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TRANSFORM_ITEM_RECIPE_SERIALIZER.get();
    }
}

