/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup.cache;

import com.davenonymous.bonsaitrees.compatibility.jei.BonsaiRecipe;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.davenonymous.bonsaitrees.setup.cache.LootCache;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import com.davenonymous.bonsaitrees.setup.data.SoilType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;

public class JeiRecipeCache {
    public static final List<BonsaiRecipe> ALL_RECIPES = new ArrayList<BonsaiRecipe>();
    public static final Map<Item, Set<BonsaiRecipe>> RECIPES_BY_INPUT = new HashMap<Item, Set<BonsaiRecipe>>();
    public static final Map<Item, Set<BonsaiRecipe>> RECIPES_BY_OUTPUT = new HashMap<Item, Set<BonsaiRecipe>>();
    public static final Map<SoilType, Set<BonsaiRecipe>> RECIPES_BY_SOILTYPE = new HashMap<SoilType, Set<BonsaiRecipe>>();

    public static void update(RegistryAccess registryAccess) {
        ALL_RECIPES.clear();
        RECIPES_BY_INPUT.clear();
        RECIPES_BY_OUTPUT.clear();
        RECIPES_BY_SOILTYPE.clear();
        BonsaiCache.BONSAI_BY_ITEM.forEach((item, bonsai) -> {
            BonsaiRecipe recipe = new BonsaiRecipe((Item)item, (BonsaiInfo)bonsai);
            ALL_RECIPES.add(recipe);
            if (!RECIPES_BY_INPUT.containsKey(item)) {
                RECIPES_BY_INPUT.put((Item)item, new HashSet());
            }
            RECIPES_BY_INPUT.get(item).add(recipe);
            bonsai.validSoilTypes(registryAccess).forEach(soilType -> {
                if (soilType == null) {
                    return;
                }
                if (!RECIPES_BY_SOILTYPE.containsKey(soilType)) {
                    RECIPES_BY_SOILTYPE.put((SoilType)soilType, new HashSet());
                }
                RECIPES_BY_SOILTYPE.get(soilType).add(recipe);
                Map<Item, Set<SoilInfo>> soilItems = SoilCache.SOIL_BY_TYPE.get(soilType.id());
                if (soilItems == null) {
                    return;
                }
                soilItems.forEach((soilItem, soilInfo) -> {
                    if (!RECIPES_BY_INPUT.containsKey(soilItem)) {
                        RECIPES_BY_INPUT.put((Item)soilItem, new HashSet());
                    }
                    RECIPES_BY_INPUT.get(soilItem).add(recipe);
                });
            });
            ResourceLocation saplingId = item.builtInRegistryHolder().getKey().location();
            if (LootCache.DROPS_BY_BONSAI.containsKey(saplingId)) {
                LootCache.DROPS_BY_BONSAI.get(saplingId).forEach(drop -> {
                    Item dropItem = drop.stack().getItem();
                    if (!RECIPES_BY_OUTPUT.containsKey(dropItem)) {
                        RECIPES_BY_OUTPUT.put(dropItem, new HashSet());
                    }
                    RECIPES_BY_OUTPUT.get(dropItem).add(recipe);
                });
            }
        });
        ALL_RECIPES.sort(Comparator.comparing(bonsai -> {
            ResourceLocation itemId = bonsai.sapling().builtInRegistryHolder().getKey().location();
            if (itemId.getNamespace().equals("minecraft")) {
                return "000" + String.valueOf(itemId);
            }
            return "999" + String.valueOf(itemId);
        }));
    }

    public static void dataMapsUpdated(DataMapsUpdatedEvent event) {
        JeiRecipeCache.update(event.getRegistries());
    }
}

