/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup.data;

import com.davenonymous.bonsaitrees.BonsaiTrees;
import com.davenonymous.bonsaitrees.setup.cache.SoilCache;
import com.davenonymous.bonsaitrees.setup.data.SoilInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SoilType(ResourceLocation id, ItemStack defaultItem, String translationKey) {
    private static final MapCodec<SoilType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(SoilType::id), (App)ItemStack.CODEC.fieldOf("defaultItem").forGetter(SoilType::defaultItem), (App)Codec.STRING.fieldOf("translationKey").forGetter(SoilType::translationKey)).apply((Applicative)instance, SoilType::new));

    public SoilType(String name, ItemStack defaultItem, String translationKey) {
        this(BonsaiTrees.resource(name), defaultItem, translationKey);
    }

    public static Codec<SoilType> codec() {
        return CODEC.codec();
    }

    public boolean hasSoils() {
        if (!SoilCache.SOIL_BY_TYPE.containsKey(this.id())) {
            return false;
        }
        Map<Item, Set<SoilInfo>> mySoils = SoilCache.SOIL_BY_TYPE.get(this.id());
        return !mySoils.isEmpty();
    }

    public boolean hasBonsais() {
        return SoilCache.BONSAIS_BY_SOIL.containsKey(this.id()) && !SoilCache.BONSAIS_BY_SOIL.get(this.id()).isEmpty();
    }
}

