/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.mixin.multiplayer;

import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.config.RocketClientModConfig;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientCommonPacketListenerImpl.class})
public class ClientCommonPacketListenerImplMixin {
    @Shadow
    @Final
    private static Component GENERIC_DISCONNECT_MESSAGE;

    @Inject(method={"createDisconnectScreen(Lnet/minecraft/network/DisconnectionDetails;)Lnet/minecraft/client/gui/screens/Screen;"}, at={@At(value="HEAD")}, cancellable=true)
    private void createDisconnectScreen(DisconnectionDetails details, CallbackInfoReturnable<Screen> ci) {
        if (RocketClientMod.getInstance().isConnectingToRocketServer() || RocketClientMod.getInstance().isOnRocketServer()) {
            LayoutTemplate template = RocketClientMod.getInstance().getLayoutRepository().getLayout((String)RocketClientModConfig.CONFIG.titleScreenLayout.get());
            if (template == null) {
                throw new IllegalStateException("Cannot find layout with id " + (String)RocketClientModConfig.CONFIG.titleScreenLayout.get());
            }
            Screen mainScreen = template.createScreen(null);
            ci.setReturnValue((Object)new DisconnectedScreen(mainScreen, GENERIC_DISCONNECT_MESSAGE, details));
        }
    }
}

