/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.rocketplatform.client.generated.GameServer;
import net.rocketplatform.client.generated.OnlineGameServerInfo;
import net.rocketplatform.client.generated.PlayerModpackServer;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketRequests;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class CompletePurchaseCallback
extends ElementCallback {
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public CompletePurchaseCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenApply(client -> client.executeSubscription(RocketRequests.PLAYER_MODPACK_SERVER_CREATED, Map.of()))).whenComplete((subscription, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to complete purchase.", e);
                return;
            }
            if (subscription == null) {
                RocketClientMod.getLogger().error("Failed to complete purchase.");
                return;
            }
            subscription.subscribe(response -> {
                subscription.unsubscribe();
                if (this.onComplete != null) {
                    OnlineGameServerInfo info;
                    GameServer gameServer;
                    variableStorage.store("gameServerId", response.getGameServerId());
                    variableStorage.store("serverIp", "");
                    variableStorage.store("serverPort", 0);
                    PlayerModpackServer playerServer = response.getPlayerServer();
                    if (playerServer != null && (gameServer = playerServer.getGameServer()) != null && (info = gameServer.getInfo()) != null) {
                        variableStorage.store("serverIp", info.getIp());
                        variableStorage.store("serverPort", info.getPort());
                    }
                    RenderSystem.recordRenderCall(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
                }
            });
        });
    }
}

