/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type.list;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.IListScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListLayoutList;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListScreenWrapper;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class ListScreen
extends BaseScreen
implements TemplateScreen,
IListScreen {
    private final Component title;
    private final AbstractListLayoutTemplate template;
    public final VariableStorage storage;
    private ListScreenWrapper wrapper;
    private int lastRefresh;

    public ListScreen(Component title, AbstractListLayoutTemplate template) {
        this.title = title;
        this.template = template;
        this.storage = new VariableStorage(template);
    }

    public void onBack() {
        if (this.template.getBack() == null) {
            super.onBack();
        } else {
            this.template.getBack().onPress(this, null, this.storage);
        }
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.onBack();
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public Component getTitle() {
        return this.title;
    }

    @Override
    public Minecraft getMinecraft() {
        return Minecraft.getInstance();
    }

    @Override
    public VariableStorage getStorage() {
        return this.storage;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public AbstractListLayoutTemplate getTemplate() {
        return this.template;
    }

    public void setWrapper(ListScreenWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void tick() {
        super.tick();
        if (this.template.getRefreshRate() <= 0) {
            return;
        }
        int refreshRate = this.template.getRefreshRate() * 20;
        if (this.lastRefresh >= refreshRate) {
            this.lastRefresh = 0;
            this.refresh();
        } else {
            ++this.lastRefresh;
        }
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean refreshListEntries) {
        if (!this.template.onRefresh(this, this.storage)) {
            this.refreshWidgets();
            if (refreshListEntries && this.wrapper != null) {
                this.wrapper.refreshEntries();
            }
        }
    }

    public void addWidgets() {
        for (ElementTemplate<?> element : this.template.getElements()) {
            if (!(element instanceof WidgetElementTemplate)) continue;
            WidgetElementTemplate ftbElement = (WidgetElementTemplate)element;
            this.add((Widget)ftbElement.createElement(this, this.width, this.height, 0, 0, this.storage));
        }
    }

    public void alignWidgets() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Panel)) continue;
            Panel panel = (Panel)widget;
            panel.alignWidgets();
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.template.renderBackground != null && this.template.renderBackground.booleanValue()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public void addMouseOverText(TooltipList list) {
        super.addMouseOverText(list);
        for (ListLayoutList.ListEntry entry : this.wrapper.list.children()) {
            for (Widget widget : entry.getWidgets()) {
                if (!widget.shouldAddMouseOverText()) continue;
                widget.addMouseOverText(list);
            }
        }
    }

    public BaseScreen getPanel() {
        return this;
    }

    public Theme getTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public ListLayoutList getList() {
        return this.wrapper.list;
    }

    @Override
    public TemplateScreen getTemplateScreen() {
        return this.wrapper.getTemplateScreen();
    }

    @Override
    public void onListCreate(Consumer<ListLayoutList> listConsumer) {
        this.wrapper.onListCreate(listConsumer);
    }
}

