/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.client.screen;

import appeng.api.config.ActionItems;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.core.AEConfig;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantic;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.network.PacketDistributor;

public class ETTerminalBaseScreen<R extends Recipe<?>, T extends ETTerminalBaseMenu<R>>
extends MEStorageScreen<T> {
    public ETTerminalBaseScreen(T menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        ActionButton clearBtn = new ActionButton(ActionItems.S_STASH, btn -> menu.clearCraftingGrid());
        clearBtn.setHalfSize(true);
        clearBtn.setDisableBackground(true);
        this.widgets.add("clearCraftingGrid", (AbstractWidget)clearBtn);
        ActionButton clearToPlayerInvBtn = new ActionButton(ActionItems.S_STASH_TO_PLAYER_INV, btn -> menu.clearToPlayerInventory());
        clearToPlayerInvBtn.setHalfSize(true);
        clearToPlayerInvBtn.setDisableBackground(true);
        this.widgets.add("clearToPlayerInv", (AbstractWidget)clearToPlayerInvBtn);
    }

    public void onClose() {
        if (AEConfig.instance().isClearGridOnClose()) {
            ((ETTerminalBaseMenu)this.getMenu()).clearCraftingGrid();
        }
        super.onClose();
    }

    protected void slotClicked(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof ETCraftingBaseSlot) {
            InventoryAction action = ETTerminalBaseScreen.hasShiftDown() ? InventoryAction.CRAFT_SHIFT : (InputConstants.isKeyDown((long)this.getMinecraft().getWindow().getWindow(), (int)32) ? InventoryAction.CRAFT_ALL : (mouseButton == 1 ? InventoryAction.CRAFT_STACK : InventoryAction.CRAFT_ITEM));
            InventoryActionPacket p = new InventoryActionPacket(action, slotIdx, 0L);
            PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        super.slotClicked(slot, slotIdx, mouseButton, clickType);
    }

    public void init() {
        super.init();
        ETMenuType menuType = ((ETTerminalBaseMenu)this.getMenu()).getETMenuType();
        this.drawCraftingSlot(menuType.getSlotSemanticGrid(), menuType.getGridSideLength());
    }

    protected void drawCraftingSlot(SlotSemantic slotSemantics, int sideLength) {
        List craftingSlots = ((ETTerminalBaseMenu)this.getMenu()).getSlots(slotSemantics);
        Slot firstSlot = (Slot)craftingSlots.getFirst();
        int craftGridStartX = firstSlot.x;
        int craftGridStartY = firstSlot.y;
        for (int row = 0; row < sideLength; ++row) {
            for (int col = 0; col < sideLength; ++col) {
                int index = row * sideLength + col;
                Slot slot = (Slot)craftingSlots.get(index);
                int x = craftGridStartX + col * 18;
                int y = craftGridStartY + row * 18;
                slot.x = x;
                slot.y = y;
            }
        }
    }
}

