/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration;

import appeng.api.stacks.AEItemKey;
import appeng.integration.modules.itemlists.EncodingHelper;
import appeng.menu.me.common.GridInventoryEntry;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapelessTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.util.TableCraftingHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class ItemListTermCraftingHelper {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    public static NonNullList<ItemStack> findGoodTemplateItems(ITableRecipeAdapter recipe, ETTerminalBaseMenu<?> menu) {
        Map ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList templateItems = NonNullList.withSize((int)menu.getCraftingGridSize(), (Object)ItemStack.EMPTY);
        NonNullList<Ingredient> ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.isEmpty()) continue;
            ItemStack stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt0$temp = e.getKey();
                return patt0$temp instanceof AEItemKey && (itemKey = (AEItemKey)patt0$temp).matches(ingredient);
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.getItems()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }

    public static Map<Integer, Ingredient> getGuiSlotToIngredientMap(ITableRecipeAdapter recipe, int gridSideLength) {
        NonNullList<Ingredient> ingredients;
        NonNullList<Ingredient> raw = recipe.recipe().getIngredients();
        int offsetX = 0;
        int offsetY = 0;
        int width = gridSideLength;
        int height = gridSideLength;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(shapedRecipe);
            width = shapedRecipe.width();
            height = shapedRecipe.height();
            offsetX = Math.floorDiv(gridSideLength - shapedRecipe.width(), 2);
            offsetY = Math.floorDiv(gridSideLength - shapedRecipe.height(), 2);
        } else {
            ingredients = raw;
        }
        int max = gridSideLength * gridSideLength;
        int count = Math.min(ingredients.size(), max);
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(count);
        for (int i = 0; i < count; ++i) {
            int x = i % width;
            int y = i / width;
            int guiSlot = (y + offsetY) * gridSideLength + (x + offsetX);
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (ing.isEmpty()) continue;
            result.put(guiSlot, ing);
        }
        return result;
    }

    public static NonNullList<Ingredient> ensureNxNTableCraftingGrid(Recipe<?> recipe, int gridSize, int recipeWidth, int recipeHeight) {
        NonNullList ingredients = recipe.getIngredients();
        NonNullList expandedIngredients = NonNullList.withSize((int)gridSize, (Object)Ingredient.EMPTY);
        if (recipeWidth == -1 || recipeHeight == -1) {
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (ingredient.isEmpty()) continue;
                expandedIngredients.set(i, (Object)ingredient);
            }
        } else {
            int cursor = 0;
            TableCraftingHelper.GridCoordinate coordinator = TableCraftingHelper.indexToCoordinate(gridSize, recipeWidth, recipeHeight);
            for (int i = 0; i < expandedIngredients.size(); ++i) {
                if (!coordinator.test(i)) continue;
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(cursor++)));
            }
        }
        return expandedIngredients;
    }

    public static NonNullList<Ingredient> ensureFittedCraftingGrid(ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> expandedIngredients;
        NonNullList ingredients = recipe.recipe().getIngredients();
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedTableRecipe = (IShapedTableRecipeAdapter)recipe;
            int width = shapedTableRecipe.width();
            int height = shapedTableRecipe.height();
            int matrixSize = width * height;
            NonNullList expandedIngredients2 = NonNullList.withSize((int)matrixSize, (Object)Ingredient.EMPTY);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int index = w + h * width;
                    if (index < ingredients.size()) {
                        expandedIngredients2.set(index, (Object)((Ingredient)ingredients.get(index)));
                        continue;
                    }
                    expandedIngredients2.set(index, (Object)Ingredient.EMPTY);
                }
            }
            return expandedIngredients2;
        }
        if (recipe instanceof IShapelessTableRecipeAdapter) {
            IShapelessTableRecipeAdapter shapelessTableRecipe = (IShapelessTableRecipeAdapter)recipe;
            expandedIngredients = TableCraftingHelper.makeNxNIngredients(shapelessTableRecipe);
            for (int i = 0; i < ingredients.size(); ++i) {
                expandedIngredients.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        } else {
            expandedIngredients = NonNullList.withSize((int)9, (Object)Ingredient.EMPTY);
        }
        return expandedIngredients;
    }
}

