/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.emi.extendedcrafting.handler;

import appeng.core.localization.ItemModText;
import appeng.menu.me.items.CraftingTermMenu;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.integration.emi.extendedcrafting.recipe.ECTableRecipe;
import me.myogoo.extendedterminal.integration.emi.handler.AbstractTableRecipeHandler;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedcrafting.ExtendedTerminalBaseMenu;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.Nullable;

public class ECTerminalRecipeHandler<T extends ExtendedTerminalBaseMenu>
extends AbstractTableRecipeHandler<T> {
    private final ETMenuType menuType;
    private final EmiRecipeCategory category;

    public ECTerminalRecipeHandler(EmiRecipeCategory category, Class<T> containerClass, ETMenuType menuType) {
        super(containerClass);
        this.menuType = menuType;
        this.category = category;
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory().equals(this.category);
    }

    @Override
    protected boolean isCraftingRecipe(Recipe<?> recipe, EmiRecipe emiRecipe) {
        if (recipe instanceof ITableRecipe) {
            ITableRecipe tableRecipe = (ITableRecipe)recipe;
            return emiRecipe.getCategory().equals(ECTableRecipe.getCategory(tableRecipe.getTier()));
        }
        return false;
    }

    @Override
    protected Map<Integer, Ingredient> getGuiSlotToIngredientMap(T menu, ITableRecipeAdapter recipe) {
        NonNullList<Ingredient> ingredients;
        int gridSideLength = ((ETTerminalBaseMenu)((Object)menu)).getCraftingGridWidth();
        NonNullList<Ingredient> raw = recipe.recipe().getIngredients();
        int offsetX = 0;
        int offsetY = 0;
        int width = gridSideLength;
        int height = gridSideLength;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            ingredients = ItemListTermCraftingHelper.ensureFittedCraftingGrid(shapedRecipe);
            width = shapedRecipe.width();
            height = shapedRecipe.height();
            offsetX = Math.floorDiv(gridSideLength - shapedRecipe.width(), 2);
            offsetY = Math.floorDiv(gridSideLength - shapedRecipe.height(), 2);
        } else {
            ingredients = raw;
        }
        int max = gridSideLength * gridSideLength;
        int count = Math.min(ingredients.size(), max);
        HashMap<Integer, Ingredient> result = new HashMap<Integer, Ingredient>(count);
        for (int i = 0; i < count; ++i) {
            int x = i % width;
            int y = i / width;
            int guiSlot = (y + offsetY) * gridSideLength + (x + offsetX);
            Ingredient ing = (Ingredient)ingredients.get(i);
            if (ing.isEmpty()) continue;
            result.put(guiSlot, ing);
        }
        return result;
    }

    @Override
    protected AbstractTableRecipeHandler.Result transferRecipe(T menu, @Nullable RecipeHolder<?> holder, EmiRecipe emiRecipe, boolean doTransfer) {
        ResourceLocation recipeId = holder != null ? holder.id() : null;
        Recipe<?> recipe = holder != null ? holder.value() : null;
        boolean craftingRecipe = this.isCraftingRecipe(recipe, emiRecipe);
        if (!craftingRecipe) {
            return AbstractTableRecipeHandler.Result.createNotApplicable();
        }
        if (!this.fitsInNxNGrid(recipe, emiRecipe, this.menuType.getGridSize())) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (recipe == null) {
            recipe = this.createFakeRecipe(emiRecipe);
        }
        if (!(recipe instanceof ITableRecipe)) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }
        ITableRecipe tableRecipe = (ITableRecipe)recipe;
        ITableRecipeAdapter adapterRecipe = ITableRecipeAdapter.of(tableRecipe);
        Map<Integer, Ingredient> slotToIngredientMap = this.getGuiSlotToIngredientMap(menu, adapterRecipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((ETTerminalBaseMenu)((Object)menu)).findMissingIngredients(slotToIngredientMap);
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            return AbstractTableRecipeHandler.Result.createFailed((Component)ItemModText.NO_ITEMS.text(), missingSlots.missingSlots());
        }
        if (!doTransfer) {
            if (missingSlots.anyMissingOrCraftable()) {
                return new AbstractTableRecipeHandler.Result.PartiallyCraftable(missingSlots);
            }
        } else {
            boolean craftMissing = AbstractContainerScreen.hasControlDown();
            this.performTransfer(menu, holder.id(), adapterRecipe, craftMissing);
        }
        return AbstractTableRecipeHandler.Result.createSuccessful();
    }

    private Recipe<?> createFakeRecipe(EmiRecipe display) {
        NonNullList ingredients = NonNullList.withSize((int)this.menuType.getGridSize(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < Math.min(display.getInputs().size(), ingredients.size()); ++i) {
            Ingredient ingredient = Ingredient.of(((EmiIngredient)display.getInputs().get(i)).getEmiStacks().stream().map(EmiStack::getItemStack).filter(is -> !is.isEmpty()));
            ingredients.set(i, (Object)ingredient);
        }
        ShapedRecipePattern pattern = new ShapedRecipePattern(this.menuType.getGridSize(), this.menuType.getGridSize(), ingredients, Optional.empty());
        return new ShapedTableRecipe(pattern, ItemStack.EMPTY, this.menuType.getTier());
    }
}

