/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.integration.jei.handler;

import appeng.core.localization.ItemModText;
import appeng.integration.modules.itemlists.TransferHelper;
import appeng.menu.me.items.CraftingTermMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.myogoo.extendedterminal.api.adapter.recipe.IShapedTableRecipeAdapter;
import me.myogoo.extendedterminal.api.adapter.recipe.ITableRecipeAdapter;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.network.serverbound.FillTableCraftingGridFromRecipePacket;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableRecipeHandler<T extends ETTerminalBaseMenu<R>, R extends Recipe<?>>
implements IRecipeTransferHandler<T, R> {
    private final Class<T> containerClass;
    private final MenuType<T> menuType;
    private final RecipeType<R> recipeType;

    public AbstractTableRecipeHandler(Class<T> containerClass, MenuType<T> menuType, RecipeType<R> recipeType) {
        this.containerClass = containerClass;
        this.menuType = menuType;
        this.recipeType = recipeType;
    }

    @NotNull
    public Class<? extends T> getContainerClass() {
        return this.containerClass;
    }

    @NotNull
    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    @NotNull
    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    protected abstract Map<Integer, Ingredient> getGuiSlotToIngredientMap(T var1, ITableRecipeAdapter var2);

    protected void performTransfer(T menu, ITableRecipeAdapter recipe, boolean craftMissing, Supplier<RecipeHolder<R>> supplier) {
        RecipeHolder<R> recipeHolder = supplier.get();
        this.performTransfer(menu, recipe, craftMissing, recipeHolder.id());
    }

    protected void performTransfer(T menu, ITableRecipeAdapter recipe, boolean craftMissing, ResourceLocation recipeId) {
        NonNullList<ItemStack> templateItems = ItemListTermCraftingHelper.findGoodTemplateItems(recipe, menu);
        int recipeWidth = -1;
        int recipeHeight = -1;
        if (recipe instanceof IShapedTableRecipeAdapter) {
            IShapedTableRecipeAdapter shapedRecipe = (IShapedTableRecipeAdapter)recipe;
            recipeWidth = shapedRecipe.width();
            recipeHeight = shapedRecipe.height();
        }
        FillTableCraftingGridFromRecipePacket message = new FillTableCraftingGridFromRecipePacket(recipeId, (List<ItemStack>)templateItems, craftMissing, recipeWidth, recipeHeight);
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected static abstract class Result
    implements IRecipeTransferError {
        protected Result() {
        }

        @NotNull
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        @Nullable
        public static IRecipeTransferError createSuccessful() {
            return null;
        }

        public static IRecipeTransferError createNotApplicable(IRecipeTransferHandlerHelper helper) {
            return helper.createInternalError();
        }

        public static IRecipeTransferError createInCompatibleError(IRecipeTransferHandlerHelper helper) {
            return helper.createUserErrorWithTooltip((Component)ItemModText.INCOMPATIBLE_RECIPE.text());
        }

        public static IRecipeTransferError createRecipeToLargeError(IRecipeTransferHandlerHelper helper) {
            return helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }

        public static final class PartiallyCraftable
        extends Result {
            private final CraftingTermMenu.MissingIngredientSlots missingSlots;
            private final boolean craftMissing;
            private final int color;

            public PartiallyCraftable(CraftingTermMenu.MissingIngredientSlots missingSlots, int color, boolean craftMissing) {
                this.missingSlots = missingSlots;
                this.craftMissing = craftMissing;
                this.color = color;
            }

            public int getButtonHighlightColor() {
                return this.color;
            }

            public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView slots, int recipeX, int recipeY) {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)recipeX, (float)recipeY, 0.0f);
                List slotViews = slots.getSlotViews(RecipeIngredientRole.INPUT);
                for (int i = 0; i < slotViews.size(); ++i) {
                    IRecipeSlotView slotView = (IRecipeSlotView)slotViews.get(i);
                    boolean missing = this.missingSlots.missingSlots().contains(i);
                    boolean craftable = this.missingSlots.craftableSlots().contains(i);
                    if (!missing && !craftable) continue;
                    slotView.drawHighlight(guiGraphics, missing ? 0x66FF0000 : 0x400000FF);
                }
                poseStack.popPose();
            }

            public int getMissingCountHint() {
                return this.missingSlots.missingSlots().size();
            }

            public void getTooltip(ITooltipBuilder tooltip) {
                tooltip.addAll((Collection)TransferHelper.createCraftingTooltip((CraftingTermMenu.MissingIngredientSlots)this.missingSlots, (boolean)this.craftMissing, (boolean)false));
            }
        }
    }
}

