/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedcrafting;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.me.storage.LinkStatusRespectingInventory;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.CraftingMatrixSlot;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import me.myogoo.extendedterminal.api.config.IETTerminalConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedcrafting.slot.ExCraftingTerminalSlot;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExtendedTerminalBaseMenu
extends ETTerminalBaseMenu<ITableRecipe> {
    private final ETCraftingBaseSlot outputSlot;
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots;
    @Nullable
    private TableCraftingInput lastTestedInput;

    public ExtendedTerminalBaseMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, ETMenuType etMenuType, IETTerminalConfig config) {
        super(menuType, id, ip, host, etMenuType, config);
        this.craftingInventoryHost = (ISegmentedInventory)host;
        this.craftingSlots = new CraftingMatrixSlot[this.menuType.getGridSize()];
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
        for (int i = 0; i < this.menuType.getGridSize(); ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot((AEBaseMenu)this, craftingGridInv, i);
            this.addSlot((Slot)this.craftingSlots[i], this.menuType.getSlotSemanticGrid());
        }
        LinkStatusRespectingInventory linkStatusInventory = new LinkStatusRespectingInventory(host.getInventory(), () -> ((ExtendedTerminalBaseMenu)this).getLinkStatus());
        this.outputSlot = new ExCraftingTerminalSlot(this.getPlayerInventory().player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, craftingGridInv, craftingGridInv, this, this.menuType);
        this.addSlot((Slot)this.outputSlot, this.menuType.getSlotSemanticResult());
        this.updateCurrentRecipeAndOutput(true);
    }

    @Override
    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClientSide());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.index, 0L);
        PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void updateCurrentRecipeAndOutput(boolean forceUpdate) {
        if (this.checkCraftingOnlyActive()) {
            return;
        }
        ArrayList<ItemStack> testItems = new ArrayList<ItemStack>(this.craftingSlots.length);
        for (CraftingMatrixSlot craftingSlot : this.craftingSlots) {
            testItems.add(craftingSlot.getItem().copy());
        }
        TableCraftingInput testInput = TableCraftingInput.of((int)this.menuType.getGridSideLength(), (int)this.menuType.getGridSideLength(), testItems, (int)this.menuType.getTier());
        if (!forceUpdate && Objects.equals(this.lastTestedInput, testInput)) {
            return;
        }
        Level level = this.getPlayer().level();
        this.currentRecipe = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)testInput, level).orElse(null);
        this.lastTestedInput = testInput;
        if (this.currentRecipe == null) {
            this.outputSlot.set(ItemStack.EMPTY);
        } else {
            this.outputSlot.set(((ITableRecipe)this.currentRecipe.value()).assemble((RecipeInput)testInput, (HolderLookup.Provider)this.registryAccess()));
        }
    }

    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        Slot slot2 = this.getSlot(slot);
        if (slot2 instanceof ExCraftingTerminalSlot) {
            ExCraftingTerminalSlot craftingSlot = (ExCraftingTerminalSlot)slot2;
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ALL: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    craftingSlot.doClick(action, (Player)player);
                }
            }
            return;
        }
        super.doAction(player, action, slot, id);
    }
}

