/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.extendedterminal;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.helpers.ICraftingGridMenu;
import appeng.helpers.InventoryAction;
import appeng.me.storage.LinkStatusRespectingInventory;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Objects;
import me.myogoo.extendedterminal.config.ETConfig;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.ETSlotSemantics;
import me.myogoo.extendedterminal.menu.ETTerminalBaseMenu;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMode;
import me.myogoo.extendedterminal.menu.extendedterminal.slot.ETSmithingSlot;
import me.myogoo.extendedterminal.menu.extendedterminal.slot.ETStoneCutterSlot;
import me.myogoo.extendedterminal.menu.slot.ETCraftingBaseSlot;
import me.myogoo.extendedterminal.part.extendedterminal.ETTerminalPart;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ETTerminalMenu
extends ETTerminalBaseMenu<CraftingRecipe> {
    public static final MenuType<ETTerminalMenu> TYPE = MenuTypeBuilder.create(ETTerminalMenu::new, ITerminalHost.class).buildUnregistered(ETMenuType.ET_TERMINAL.getId());
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots;
    private final CraftingTermSlot outputSlot;
    private final CraftingMatrixSlot smithingTemplateSlot;
    private final CraftingMatrixSlot smithingBaseSlot;
    private final CraftingMatrixSlot smithingAdditionSlot;
    private final ETSmithingSlot smithingOutputSlot;
    private final CraftingMatrixSlot stonecuttingSlot;
    private final ETStoneCutterSlot stonecuttingOutputSlot;
    @Nullable
    private CraftingInput lastTestedInput;
    private ETTerminalMode currentMode = ETTerminalMode.CRAFTING;

    public ETTerminalMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host) {
        super(menuType, id, ip, host, ETMenuType.ET_TERMINAL, ETConfig.ADVANCED_TERMINAL_CONFIG);
        this.craftingInventoryHost = (ISegmentedInventory)host;
        this.craftingSlots = new CraftingMatrixSlot[this.menuType.getGridSize()];
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
        for (int i = 0; i < this.menuType.getGridSize(); ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot((AEBaseMenu)this, craftingGridInv, i);
            this.addSlot((Slot)this.craftingSlots[i], this.menuType.getSlotSemanticGrid());
        }
        LinkStatusRespectingInventory linkStatusInventory = new LinkStatusRespectingInventory(host.getInventory(), () -> ((ETTerminalMenu)this).getLinkStatus());
        this.outputSlot = new CraftingTermSlot(this.getPlayerInventory().player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, craftingGridInv, craftingGridInv, (ICraftingGridMenu)this);
        this.addSlot((Slot)this.outputSlot, this.menuType.getSlotSemanticResult());
        InternalInventory smithingInv = this.craftingInventoryHost.getSubInventory(ETTerminalPart.SmithingInventory);
        this.smithingTemplateSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 0);
        this.addSlot((Slot)this.smithingTemplateSlot, SlotSemantics.SMITHING_TABLE_TEMPLATE);
        this.smithingBaseSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 1);
        this.addSlot((Slot)this.smithingBaseSlot, SlotSemantics.SMITHING_TABLE_BASE);
        this.smithingAdditionSlot = new CraftingMatrixSlot((AEBaseMenu)this, smithingInv, 2);
        this.addSlot((Slot)this.smithingAdditionSlot, SlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingOutputSlot = new ETSmithingSlot(this.getPlayerInventory().player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, smithingInv, smithingInv, this);
        this.addSlot((Slot)this.smithingOutputSlot, SlotSemantics.SMITHING_TABLE_RESULT);
        InternalInventory stonecuttingInv = this.craftingInventoryHost.getSubInventory(ETTerminalPart.StoneCutterInventory);
        this.stonecuttingSlot = new CraftingMatrixSlot((AEBaseMenu)this, stonecuttingInv, 0);
        this.addSlot((Slot)this.stonecuttingSlot, SlotSemantics.STONECUTTING_INPUT);
        this.stonecuttingOutputSlot = new ETStoneCutterSlot(this.getPlayerInventory().player, this.getActionSource(), this.energySource, (MEStorage)linkStatusInventory, stonecuttingInv, stonecuttingInv, this);
        this.addSlot((Slot)this.stonecuttingOutputSlot, ETSlotSemantics.STONECUTTING_RESULT);
        this.updateCurrentRecipeAndOutput(true);
    }

    @Override
    protected void updateCurrentRecipeAndOutput(boolean forceUpdate) {
        switch (this.currentMode) {
            case CRAFTING: {
                this.updateCraftingOutput(forceUpdate);
                break;
            }
            case SMITHING: {
                this.updateSmithingOutput(forceUpdate);
                break;
            }
            case STONECUTTING: {
                this.updateStonecuttingOutput(forceUpdate);
            }
        }
    }

    @Override
    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClientSide());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.index, 0L);
        PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(this.menuType.getCraftingInventory());
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        Slot slot2 = this.getSlot(slot);
        if (slot2 instanceof ETCraftingBaseSlot) {
            ETCraftingBaseSlot craftingSlot = (ETCraftingBaseSlot)slot2;
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ALL: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    craftingSlot.doClick(action, (Player)player);
                }
            }
            return;
        }
        super.doAction(player, action, slot, id);
    }

    public RecipeHolder<StonecutterRecipe> getStoneCutterRecipe() {
        if (this.currentMode != ETTerminalMode.STONECUTTING) {
            return null;
        }
        Level level = this.getPlayer().level();
        SingleRecipeInput a = new SingleRecipeInput(this.stonecuttingSlot.getItem());
        return level.getRecipeManager().getRecipeFor(RecipeType.STONECUTTING, (RecipeInput)a, level).orElse(null);
    }

    private void updateSmithingOutput(boolean forceUpdate) {
        Level level = this.getPlayer().level();
        SmithingRecipeInput smithingTestInput = new SmithingRecipeInput(this.smithingTemplateSlot.getItem(), this.smithingBaseSlot.getItem(), this.smithingAdditionSlot.getItem());
        RecipeHolder smithingRecipe = level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (RecipeInput)smithingTestInput, level).orElse(null);
        if (smithingRecipe == null) {
            this.smithingOutputSlot.set(ItemStack.EMPTY);
        } else {
            this.smithingOutputSlot.set(((SmithingRecipe)smithingRecipe.value()).assemble((RecipeInput)smithingTestInput, (HolderLookup.Provider)level.registryAccess()));
        }
    }

    private void updateStonecuttingOutput(boolean forceUpdate) {
        Level level = this.getPlayer().level();
        SingleRecipeInput testInput = new SingleRecipeInput(this.stonecuttingSlot.getItem());
        RecipeHolder stonecutterRecipe = level.getRecipeManager().getRecipeFor(RecipeType.STONECUTTING, (RecipeInput)testInput, level).orElse(null);
        if (stonecutterRecipe == null) {
            this.stonecuttingOutputSlot.set(ItemStack.EMPTY);
        } else {
            this.stonecuttingOutputSlot.set(((StonecutterRecipe)stonecutterRecipe.value()).assemble(testInput, (HolderLookup.Provider)level.registryAccess()));
        }
    }

    private void updateCraftingOutput(boolean forceUpdate) {
        ArrayList<ItemStack> testItems = new ArrayList<ItemStack>(this.craftingSlots.length);
        for (CraftingMatrixSlot craftingSlot : this.craftingSlots) {
            testItems.add(craftingSlot.getItem().copy());
        }
        CraftingInput testInput = CraftingInput.of((int)3, (int)3, testItems);
        if (!forceUpdate && Objects.equals(this.lastTestedInput, testInput)) {
            return;
        }
        Level level = this.getPlayer().level();
        this.currentRecipe = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)testInput, level).orElse(null);
        this.lastTestedInput = testInput;
        if (this.currentRecipe == null) {
            this.outputSlot.set(ItemStack.EMPTY);
        } else {
            this.outputSlot.set(((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)testInput, (HolderLookup.Provider)level.registryAccess()));
        }
    }
}

