/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.menu.slot;

import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.helpers.ICraftingGridMenu;
import appeng.helpers.InventoryAction;
import appeng.menu.slot.AppEngCraftingSlot;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import java.util.ArrayList;
import java.util.List;
import me.myogoo.extendedterminal.menu.ETMenuType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public abstract class ETCraftingBaseSlot<R extends Recipe<?>, I extends RecipeInput>
extends AppEngCraftingSlot {
    protected final InternalInventory craftInv;
    private final InternalInventory pattern;
    protected final IActionSource mySrc;
    protected final IEnergySource energySrc;
    protected final ICraftingGridMenu menu;
    private final MEStorage storage;
    protected final ETMenuType menuType;

    public ETCraftingBaseSlot(Player player, IActionSource mySrc, IEnergySource energySrc, MEStorage storage, InternalInventory cMatrix, InternalInventory secondMatrix, ICraftingGridMenu ccp, ETMenuType menuType) {
        super(player, cMatrix);
        this.energySrc = energySrc;
        this.storage = storage;
        this.mySrc = mySrc;
        this.pattern = cMatrix;
        this.craftInv = secondMatrix;
        this.menu = ccp;
        this.menuType = menuType;
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    public void onTake(Player player, ItemStack is) {
    }

    public void doClick(InventoryAction action, Player who) {
        int maxTimesToCraft;
        PlayerInternalInventory target;
        if (this.getItem().isEmpty()) {
            return;
        }
        if (this.isRemote()) {
            return;
        }
        int howManyPerCraft = this.getItem().getCount();
        if (action == InventoryAction.CRAFT_SHIFT || action == InventoryAction.CRAFT_ALL) {
            target = new PlayerInternalInventory(who.getInventory());
            maxTimesToCraft = action == InventoryAction.CRAFT_SHIFT ? (int)Math.floor((double)this.getItem().getMaxStackSize() / (double)howManyPerCraft) : (int)Math.floor((double)this.getItem().getMaxStackSize() / (double)howManyPerCraft * 36.0);
        } else if (action == InventoryAction.CRAFT_STACK) {
            target = new CarriedItemInventory((AbstractContainerMenu)this.getMenu());
            maxTimesToCraft = (int)Math.floor((double)this.getItem().getMaxStackSize() / (double)howManyPerCraft);
        } else {
            if (this.getMenu().getCarried().isEmpty()) {
                this.getMenu().setCarried(this.craftItem(who, this.storage, this.storage.getAvailableStacks()));
                return;
            }
            target = new CarriedItemInventory((AbstractContainerMenu)this.getMenu());
            maxTimesToCraft = 1;
        }
        ItemStack itemAtStart = this.getItem().copy();
        if (itemAtStart.isEmpty()) {
            return;
        }
        for (int x = 0; x < maxTimesToCraft; ++x) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemAtStart, (ItemStack)this.getItem())) {
                return;
            }
            if (!target.simulateAdd(itemAtStart).isEmpty()) {
                return;
            }
            KeyCounter all = this.storage.getAvailableStacks();
            ItemStack extra = target.addItems(this.craftItem(who, this.storage, all));
            if (extra.isEmpty()) continue;
            Platform.spawnDrops((Level)who.level(), (BlockPos)who.blockPosition(), List.of(extra));
            return;
        }
    }

    protected abstract RecipeHolder<R> findRecipe(I var1, Level var2);

    protected abstract NonNullList<ItemStack> getETRemainingItems(I var1, Level var2);

    protected abstract void makeItem(Player var1, ItemStack var2);

    protected abstract ItemStack craftItem(Player var1, MEStorage var2, KeyCounter var3);

    protected void postCraft(Player p, MEStorage inv, ItemStack[] set, ItemStack result) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!p.getCommandSenderWorld().isClientSide()) {
            for (int x = 0; x < this.craftInv.size(); ++x) {
                int amount;
                AEItemKey what;
                long inserted;
                if (this.craftInv.getStackInSlot(x).isEmpty()) {
                    this.craftInv.setItemDirect(x, set[x]);
                    continue;
                }
                if (set[x].isEmpty() || (inserted = inv.insert((AEKey)(what = AEItemKey.of((ItemStack)set[x])), (long)(amount = set[x].getCount()), Actionable.MODULATE, this.mySrc)) >= (long)amount) continue;
                drops.add(what.toStack((int)((long)amount - inserted)));
            }
        }
        if (!drops.isEmpty()) {
            Platform.spawnDrops((Level)p.level(), (BlockPos)new BlockPos((int)p.getX(), (int)p.getY(), (int)p.getZ()), drops);
        }
    }

    protected InternalInventory getPattern() {
        return this.pattern;
    }
}

