/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.network.serverbound;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.network.ServerboundPacket;
import appeng.helpers.ICraftingGridMenu;
import appeng.items.storage.ViewCellItem;
import appeng.me.storage.NullInventory;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.integration.ItemListTermCraftingHelper;
import me.myogoo.extendedterminal.network.serverbound.FillRecipeBasePacket;
import me.myogoo.extendedterminal.util.TableCraftingHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class FillTableCraftingGridFromRecipePacket
extends FillRecipeBasePacket
implements ServerboundPacket {
    public static final int NOT_SET_RECIPE_SIZE = -1;
    public static final StreamCodec<RegistryFriendlyByteBuf, FillTableCraftingGridFromRecipePacket> STREAM_CODEC = StreamCodec.ofMember(FillTableCraftingGridFromRecipePacket::write, FillTableCraftingGridFromRecipePacket::decode);
    public static final CustomPacketPayload.Type<FillTableCraftingGridFromRecipePacket> TYPE = new CustomPacketPayload.Type(ExtendedTerminal.makeId("fill_table_crafting_grid_from_recipe"));
    private final List<ItemStack> ingredientTemplates;
    private final boolean craftMissing;
    private final int recipeWidth;
    private final int recipeHeight;
    private final ResourceLocation recipeId;

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CustomPacketPayload.Type<FillTableCraftingGridFromRecipePacket> type() {
        return TYPE;
    }

    public FillTableCraftingGridFromRecipePacket(ResourceLocation recipeId, List<ItemStack> ingredientTemplates, boolean craftMissing, int recipeWidth, int recipeHeight) {
        this.recipeId = recipeId;
        this.ingredientTemplates = NonNullList.copyOf(ingredientTemplates.stream().map(ItemStack::copy).toList());
        this.craftMissing = craftMissing;
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
    }

    public void write(RegistryFriendlyByteBuf stream) {
        if (this.recipeId != null) {
            stream.writeBoolean(true);
            stream.writeResourceLocation(this.recipeId);
        } else {
            stream.writeBoolean(false);
        }
        stream.writeInt(this.ingredientTemplates.size());
        for (ItemStack ingredientTemplate : this.ingredientTemplates) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)stream, (Object)ingredientTemplate);
        }
        stream.writeBoolean(this.craftMissing);
        stream.writeInt(this.recipeWidth);
        stream.writeInt(this.recipeHeight);
    }

    public static FillTableCraftingGridFromRecipePacket decode(RegistryFriendlyByteBuf stream) {
        ResourceLocation recipeId = null;
        if (stream.readBoolean()) {
            recipeId = stream.readResourceLocation();
        }
        NonNullList ingredientTemplates = NonNullList.withSize((int)stream.readInt(), (Object)ItemStack.EMPTY);
        ingredientTemplates.replaceAll(ignored -> (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)stream));
        boolean craftMissing = stream.readBoolean();
        int recipeWidth = stream.readInt();
        int recipeHeight = stream.readInt();
        return new FillTableCraftingGridFromRecipePacket(recipeId, (List<ItemStack>)ingredientTemplates, craftMissing, recipeWidth, recipeHeight);
    }

    @Override
    protected NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Optional recipe;
        if (this.recipeId != null && (recipe = player.level().getRecipeManager().byKey(this.recipeId)).isPresent()) {
            return ItemListTermCraftingHelper.ensureNxNTableCraftingGrid(((RecipeHolder)recipe.get()).value(), this.ingredientTemplates.size(), this.recipeWidth, this.recipeHeight);
        }
        NonNullList ingredients = NonNullList.withSize((int)this.ingredientTemplates.size(), (Object)Ingredient.EMPTY);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got {} ingredient templates from client, expected {}", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        if (this.recipeWidth == -1 || this.recipeHeight == -1) {
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack template = this.ingredientTemplates.get(i);
                if (template.isEmpty()) continue;
                ingredients.set(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{template}));
            }
        } else {
            int cursor = 0;
            TableCraftingHelper.GridCoordinate coordinator = TableCraftingHelper.indexToCoordinate(this.ingredientTemplates.size(), this.recipeWidth, this.recipeHeight);
            for (int i = 0; i < ingredients.size(); ++i) {
                if (!coordinator.test(i)) continue;
                ingredients.set(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{this.ingredientTemplates.get(cursor++)}));
            }
        }
        return ingredients;
    }

    public void handleOnServer(ServerPlayer player) {
        KeyCounter cachedStorage;
        MEStorage networkStorage;
        IStorageService storageService;
        ICraftingService craftingService;
        AbstractContainerMenu menu = player.containerMenu;
        if (!(menu instanceof ICraftingGridMenu)) {
            return;
        }
        ICraftingGridMenu cct = (ICraftingGridMenu)menu;
        IEnergySource energy = cct.getEnergySource();
        IGridNode node = cct.getGridNode();
        if (node != null && cct.getLinkStatus().connected()) {
            craftingService = node.getGrid().getCraftingService();
            storageService = node.getGrid().getStorageService();
            networkStorage = storageService.getInventory();
            cachedStorage = storageService.getCachedInventory();
        } else {
            craftingService = null;
            storageService = null;
            networkStorage = NullInventory.of();
            cachedStorage = new KeyCounter();
        }
        InternalInventory craftMatrix = cct.getCraftingMatrix();
        IPartitionList filter = ViewCellItem.createItemFilter((Collection)cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        LinkedHashMap toAutoCraft = new LinkedHashMap();
        boolean touchedGridStorage = false;
        for (int x = 0; x < craftMatrix.size(); ++x) {
            ItemStack currentItem = craftMatrix.getStackInSlot(x);
            Ingredient ingredient = (Ingredient)ingredients.get(x);
            if (!currentItem.isEmpty()) {
                if (ingredient.test(currentItem)) continue;
                AEItemKey in = AEItemKey.of((ItemStack)currentItem);
                long inserted = StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)in, (long)currentItem.getCount(), (IActionSource)cct.getActionSource());
                if (inserted > 0L) {
                    touchedGridStorage = true;
                }
                if (inserted < (long)currentItem.getCount()) {
                    currentItem = currentItem.copy();
                    currentItem.shrink((int)inserted);
                } else {
                    currentItem = ItemStack.EMPTY;
                }
                player.getInventory().add(currentItem);
                craftMatrix.setItemDirect(x, currentItem.isEmpty() ? ItemStack.EMPTY : currentItem);
            }
            if (ingredient.isEmpty()) continue;
            if (currentItem.isEmpty()) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)networkStorage, (AEKey)what, (long)1L, (IActionSource)cct.getActionSource());
                    if (extracted <= 0L) continue;
                    touchedGridStorage = true;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.isEmpty()) {
                currentItem = this.takeIngredientFromPlayer(cct, player, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
            if (!currentItem.isEmpty() || !this.craftMissing || craftingService == null) continue;
            int slot = x;
            this.findCraftableKey(ingredient, craftingService).ifPresent(key -> toAutoCraft.computeIfAbsent(key, k -> new IntArrayList()).add(slot));
        }
        menu.slotsChanged(craftMatrix.toContainer());
        if (!toAutoCraft.isEmpty()) {
            if (touchedGridStorage) {
                storageService.invalidateCache();
            }
            List<ICraftingGridMenu.AutoCraftEntry> stacks = toAutoCraft.entrySet().stream().map(e -> new ICraftingGridMenu.AutoCraftEntry((AEItemKey)e.getKey(), (List)e.getValue())).toList();
            cct.startAutoCrafting(stacks);
        }
    }
}

