/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.part.extendedterminal;

import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import me.myogoo.extendedterminal.ExtendedTerminal;
import me.myogoo.extendedterminal.menu.ETMenuType;
import me.myogoo.extendedterminal.menu.extendedterminal.ETTerminalMenu;
import me.myogoo.extendedterminal.part.ETTerminalBasePart;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ETTerminalPart
extends ETTerminalBasePart {
    public static final ResourceLocation SmithingInventory = ExtendedTerminal.makeId("smithing_crafting_inventory");
    public static final ResourceLocation StoneCutterInventory = ExtendedTerminal.makeId("stonecutter_crafting_inventory");
    private final AppEngInternalInventory smithingGrid = new AppEngInternalInventory((InternalInventoryHost)this, 3);
    private final AppEngInternalInventory stoneCutterGrid = new AppEngInternalInventory((InternalInventoryHost)this, 1);

    public ETTerminalPart(IPartItem<?> partItem) {
        super(partItem, ETMenuType.ET_TERMINAL);
    }

    @Override
    public void clearContent() {
        super.clearContent();
        this.smithingGrid.clear();
        this.stoneCutterGrid.clear();
    }

    public MenuType<?> getMenuType(Player p) {
        return ETTerminalMenu.TYPE;
    }

    public IPartModel getStaticModels() {
        return this.selectModel(CraftingTerminalPart.MODELS_ON, CraftingTerminalPart.MODELS_OFF, CraftingTerminalPart.MODELS_HAS_CHANNEL);
    }

    @Override
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)SmithingInventory)) {
            return this.smithingGrid;
        }
        if (id.equals((Object)StoneCutterInventory)) {
            return this.stoneCutterGrid;
        }
        return super.getSubInventory(id);
    }

    @Override
    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        this.smithingGrid.writeToNBT(data, "smithingGrid", registries);
        this.stoneCutterGrid.writeToNBT(data, "stoneCutterGrid", registries);
    }

    @Override
    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.smithingGrid.readFromNBT(data, "smithingGrid", registries);
        this.stoneCutterGrid.readFromNBT(data, "stoneCutterGrid", registries);
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.smithingGrid) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
        for (ItemStack is : this.stoneCutterGrid) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }
}

