/*
 * Decompiled with CFR 0.152.
 */
package me.myogoo.extendedterminal.util;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import java.util.List;
import java.util.Map;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class ShapedTableRecipeBuilder
extends ShapedRecipeBuilder {
    private int tier = 0;

    public ShapedTableRecipeBuilder(ItemLike result, int count) {
        super(RecipeCategory.MISC, result, count);
    }

    public static ShapedTableRecipeBuilder shaped(ItemLike result, int count) {
        return new ShapedTableRecipeBuilder(result, count);
    }

    public ShapedTableRecipeBuilder tier(int tier) {
        if (tier < 0 || tier > 4) {
            throw new IllegalArgumentException("Tier must be between 0 and 4");
        }
        this.tier = tier;
        return this;
    }

    public ShapedTableRecipeBuilder pattern(String pattern) {
        super.pattern(pattern);
        return this;
    }

    public ShapedTableRecipeBuilder define(char key, ItemLike item) {
        super.define(Character.valueOf(key), item);
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.of((Map)this.key, (List)this.rows);
        ShapedTableRecipe shapedTableRecipe = new ShapedTableRecipe(shapedrecipepattern, this.getResult().getDefaultInstance(), this.tier);
        recipeOutput.accept(id, (Recipe)shapedTableRecipe, null);
    }

    public RecipeHolder<ITableRecipe> buildEC(ResourceLocation id) {
        ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.of((Map)this.key, (List)this.rows);
        return new RecipeHolder(id, (Recipe)new ShapedTableRecipe(shapedrecipepattern, this.getResult().getDefaultInstance(), this.tier));
    }

    public RecipeHolder<ITierCraftingRecipe> buildReAV(ResourceLocation id) {
        ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.of((Map)this.key, (List)this.rows);
        return new RecipeHolder(id, (Recipe)new ShapedTableCraftingRecipe(shapedrecipepattern, this.getResult().getDefaultInstance(), this.tier));
    }

    public RecipeHolder<RecipeExtremeCrafting> buildAVNeo(ResourceLocation id) {
        ShapedRecipePattern shapedrecipepattern = ShapedRecipePattern.of((Map)this.key, (List)this.rows);
        return new RecipeHolder(id, (Recipe)new RecipeExtremeShaped("", shapedrecipepattern, this.getResult().getDefaultInstance()));
    }
}

