/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block;

import com.cyanogen.cognition.block.ExperienceReceivingBlock;
import com.cyanogen.cognition.block_entities.LinearAcceleratorEntity;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.registries.RegisterItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LinearAcceleratorBlock
extends ExperienceReceivingBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public LinearAcceleratorBlock() {
        super(BlockBehaviour.Properties.of().strength(9.0f).sound(SoundType.NETHERITE_BLOCK).destroyTime(1.2f).requiresCorrectToolForDrops().explosionResistance(9.0f).friction(0.98f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if (!((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            return 0.6f;
        }
        return super.getFriction(state, level, pos, entity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{ACTIVE});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction looking = context.getHorizontalDirection();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)looking)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)RegisterItems.ATTUNEMENT_STAFF.get()) && !player.isShiftKeyDown()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            state = (BlockState)state.setValue((Property)FACING, (Comparable)direction.getClockWise());
            level.setBlockAndUpdate(pos, state);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.LINEAR_ACCELERATOR.get() ? LinearAcceleratorEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.LINEAR_ACCELERATOR.get()).create(pos, state);
    }
}

