/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.PrecisionDispellerEntity;
import com.cyanogen.cognition.gui.PrecisionDispellerMenu;
import com.cyanogen.cognition.network.precision_dispeller.UpdateSlot;
import com.cyanogen.cognition.utils.EnchantmentUtils;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class PrecisionDispellerScreen
extends AbstractContainerScreen<PrecisionDispellerMenu> {
    private final ResourceLocation texture = ResourceLocation.parse((String)"cognition:textures/gui/screens/precision_dispeller.png");
    private final Component title = Component.translatable((String)"title.cognition.precision_dispeller");
    private final Component inventoryTitle = Component.translatable((String)"title.cognition.precision_dispeller.inventory");
    private final Level clientLevel;
    private final ArrayList<SelectablePanel> selectablePanels = new ArrayList();
    public int selectedIndex = -1;
    int scrollButtonPos = 18;
    int offset = 0;
    boolean scrollClicked = false;
    boolean scrollEnabled = false;
    int clickedDelta = -1;

    public PrecisionDispellerScreen(PrecisionDispellerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.clientLevel = inventory.player.level();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.selectablePanels.clear();
        this.renderTransparentBackground(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gui.blit(this.texture, x, y, 0, 0, 176, 166);
        super.render(gui, mouseX, mouseY, partialTick);
        ItemStack inputStack = ((PrecisionDispellerMenu)this.menu).container.getItem(0);
        HashMap<Holder<Enchantment>, Integer> enchantmentMap = EnchantmentUtils.getEnchantmentMap(inputStack);
        boolean bl = this.scrollEnabled = enchantmentMap.size() > 3;
        if ((inputStack.isEnchanted() || inputStack.is(Items.ENCHANTED_BOOK)) && this.scrollEnabled) {
            gui.blit(this.texture, x + 153, y + this.scrollButtonPos, 177.0f, 0.0f, 9, 13, 256, 256);
        } else {
            this.scrollButtonPos = 18;
            gui.blit(this.texture, x + 153, y + 18, 187.0f, 0.0f, 9, 13, 256, 256);
        }
        if (!enchantmentMap.isEmpty()) {
            int index = 0;
            for (Map.Entry<Holder<Enchantment>, Integer> entry : enchantmentMap.entrySet()) {
                int n = enchantmentMap.size() - 3;
                int b = this.scrollButtonPos - 18;
                if (n > 0) {
                    this.offset = -b * 17 * n / 38;
                }
                int xpos = x + 49;
                int ypos = y + 18 + 17 * index + this.offset;
                boolean visibility = ypos > y + 1 && ypos < y + 69;
                this.selectablePanels.add(new SelectablePanel(xpos, ypos, entry.getKey(), entry.getValue(), Status.UNHOVERED, visibility, gui, this.texture));
                ++index;
            }
            for (SelectablePanel panel : this.selectablePanels) {
                if (this.selectablePanels.indexOf(panel) == this.selectedIndex) {
                    panel.status = Status.SELECTED;
                } else if (panel.isHovered(mouseX, mouseY)) {
                    panel.status = Status.HOVERED;
                }
                if (!panel.isVisible) continue;
                panel.renderPanel(gui);
            }
            for (SelectablePanel panel : this.selectablePanels) {
                if (!panel.isVisible) continue;
                panel.renderText(this.font);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            gui.pose().translate(0.0f, 0.0f, 1.0f);
            gui.blit(this.texture, x + 49, y + 1, 49.0f, 1.0f, 102, 17, 256, 256);
            gui.blit(this.texture, x + 49, y + 69, 49.0f, 69.0f, 102, 17, 256, 256);
        } else {
            this.selectedIndex = -1;
            this.offset = 0;
        }
        this.renderTitles(gui, x + 8, y + 6, x + 8, y + 72);
        this.renderPanelTooltip(gui, mouseX, mouseY);
        this.renderTooltip(gui, mouseX, mouseY);
    }

    protected void renderPanelTooltip(GuiGraphics gui, int x, int y) {
        BlockPos pos = ((PrecisionDispellerMenu)this.menu).getBlockPos();
        long playerXP = ExperienceUtils.levelsToXP(((PrecisionDispellerMenu)this.menu).player.experienceLevel) + (long)Math.round(((PrecisionDispellerMenu)this.menu).player.experienceProgress * (float)((PrecisionDispellerMenu)this.menu).player.getXpNeededForNextLevel());
        for (SelectablePanel panel : this.selectablePanels) {
            if (!panel.isHovered(x, y) || !panel.isVisible || panel.status.equals((Object)Status.SELECTED)) continue;
            ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
            tooltipList.add(Component.literal((String)panel.getFullName()));
            if (panel.enchantment.is(EnchantmentTags.CURSE)) {
                PrecisionDispellerEntity dispeller;
                BlockEntity blockEntity;
                tooltipList.add(Component.translatable((String)"tooltip.cognition.precision_dispeller.curse"));
                if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof PrecisionDispellerEntity && ((dispeller = (PrecisionDispellerEntity)blockEntity).getBoundObelisk() == null && playerXP < 1395L || dispeller.getBoundObelisk() != null && (long)dispeller.getBoundObelisk().getExperiencePoints() + playerXP < 1395L)) {
                    tooltipList.add(Component.translatable((String)"tooltip.cognition.precision_dispeller.insufficient_xp"));
                }
            } else {
                int points = ((Enchantment)panel.enchantment.value()).getMinCost(panel.level);
                int levels = ExperienceUtils.xpToLevels(points);
                MutableComponent pts = Component.translatable((String)String.valueOf(points)).withStyle(ChatFormatting.GREEN);
                MutableComponent lvls = Component.translatable((String)String.valueOf(levels)).withStyle(ChatFormatting.GREEN);
                tooltipList.add(Component.translatable((String)"tooltip.cognition.precision_dispeller.enchantment", (Object[])new Object[]{lvls, pts}));
            }
            gui.renderTooltip(this.font, tooltipList, Optional.empty(), x, y);
        }
    }

    protected void renderTitles(GuiGraphics gui, int titleX, int titleY, int inventoryX, int inventoryY) {
        gui.drawString(this.font, this.title, titleX, titleY, 0xFFFFFF);
        gui.drawString(this.font, this.inventoryTitle, inventoryX, inventoryY, 0xFFFFFF);
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics gui, float f, int a, int b) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= (double)(x + 48) && mouseX <= (double)(x + 162) && mouseY >= (double)(y + 17) && mouseY <= (double)(y + 69) && this.scrollEnabled) {
            this.scrollButtonPos -= 4 * (int)scrollY;
        }
        if (this.scrollButtonPos > 56) {
            this.scrollButtonPos = 56;
        } else if (this.scrollButtonPos < 18) {
            this.scrollButtonPos = 18;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrollClicked = false;
        this.clickedDelta = -1;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int y = (this.height - this.imageHeight) / 2;
        if (this.scrollClicked && this.clickedDelta != -1 && this.scrollEnabled) {
            this.scrollButtonPos = (int)mouseY - y - this.clickedDelta;
        }
        if (this.scrollButtonPos > 56) {
            this.scrollButtonPos = 56;
        } else if (this.scrollButtonPos < 18) {
            this.scrollButtonPos = 18;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= (double)(x + 152) && mouseX <= (double)(x + 162) && mouseY >= (double)(y + this.scrollButtonPos) && mouseY <= (double)(y + this.scrollButtonPos + 13) && this.scrollEnabled) {
            this.scrollClicked = true;
            this.clickedDelta = (int)mouseY - (y + this.scrollButtonPos);
        } else {
            this.mouseClickedOnPanel(mouseX, mouseY);
        }
        return true;
    }

    public void mouseClickedOnPanel(double mouseX, double mouseY) {
        BlockPos pos = ((PrecisionDispellerMenu)this.menu).getBlockPos();
        long playerXP = ExperienceUtils.levelsToXP(((PrecisionDispellerMenu)this.menu).player.experienceLevel) + (long)Math.round(((PrecisionDispellerMenu)this.menu).player.experienceProgress * (float)((PrecisionDispellerMenu)this.menu).player.getXpNeededForNextLevel());
        for (SelectablePanel panel : this.selectablePanels) {
            BlockEntity blockEntity;
            boolean invalid = true;
            if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof PrecisionDispellerEntity) {
                PrecisionDispellerEntity dispeller = (PrecisionDispellerEntity)blockEntity;
                if (((PrecisionDispellerMenu)this.menu).player.isCreative() || !panel.enchantment.is(EnchantmentTags.CURSE)) {
                    invalid = false;
                } else if (playerXP >= 1395L) {
                    invalid = false;
                } else if (dispeller.getBoundObelisk() != null) {
                    boolean bl = invalid = playerXP + (long)dispeller.getBoundObelisk().getExperiencePoints() < 1395L;
                }
            }
            if (!panel.isHovered(mouseX, mouseY) || !panel.isVisible || invalid) continue;
            if (this.selectedIndex == this.selectablePanels.indexOf(panel)) {
                this.selectedIndex = -1;
                Tag tag = ItemStack.EMPTY.saveOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSlot(1, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                ItemStack outputItem;
                this.selectedIndex = this.selectablePanels.indexOf(panel);
                ItemStack inputItem = ((PrecisionDispellerMenu)this.menu).container.getItem(0);
                HashMap<Holder<Enchantment>, Integer> map = EnchantmentUtils.getEnchantmentMap(inputItem);
                map.remove(panel.enchantment);
                if (inputItem.is(Items.ENCHANTED_BOOK)) {
                    if (map.isEmpty()) {
                        outputItem = new ItemStack((ItemLike)Items.BOOK, 1);
                    } else {
                        outputItem = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, 1);
                        EnchantmentHelper.setEnchantments((ItemStack)outputItem, (ItemEnchantments)EnchantmentUtils.getItemEnchantmentsFromMap(map));
                    }
                } else {
                    outputItem = inputItem.copy();
                    EnchantmentHelper.setEnchantments((ItemStack)outputItem, (ItemEnchantments)EnchantmentUtils.getItemEnchantmentsFromMap(map));
                    int repairCost = (Integer)outputItem.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                    repairCost = (repairCost - 1) / 2;
                    if (repairCost < 1 || !outputItem.isEnchanted()) {
                        repairCost = 0;
                    }
                    outputItem.set(DataComponents.REPAIR_COST, (Object)repairCost);
                }
                Tag tag = outputItem.saveOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                PacketDistributor.sendToServer((CustomPacketPayload)new UpdateSlot(1, tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    private static class SelectablePanel {
        public Holder<Enchantment> enchantment;
        public int level;
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public Status status;
        boolean isVisible;
        GuiGraphics gui;
        ResourceLocation texture;

        private SelectablePanel(int x1, int y1, Holder<Enchantment> e, int level, Status s, boolean isVisible, GuiGraphics gui, ResourceLocation texture) {
            this.enchantment = e;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x1 + 102;
            this.y2 = y1 + 17;
            this.level = level;
            this.status = s;
            this.isVisible = isVisible;
            this.gui = gui;
            this.texture = texture;
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX > (double)this.x1 && mouseX < (double)this.x2 && mouseY > (double)this.y1 && mouseY < (double)this.y2;
        }

        public void renderPanel(GuiGraphics gui) {
            switch (this.status.ordinal()) {
                case 0: {
                    gui.blit(this.texture, this.x1, this.y1, 0.0f, 177.0f, 102, 17, 256, 256);
                    break;
                }
                case 1: {
                    gui.blit(this.texture, this.x1, this.y1, 0.0f, 211.0f, 102, 17, 256, 256);
                    break;
                }
                case 2: {
                    gui.blit(this.texture, this.x1, this.y1, 0.0f, 194.0f, 102, 17, 256, 256);
                }
            }
        }

        public String getFullName() {
            return Enchantment.getFullname(this.enchantment, (int)this.level).getString();
        }

        public void renderText(Font font) {
            Object text = this.getFullName();
            if (font.width((String)text) > 90) {
                while (font.width((String)text) > 90) {
                    text = ((String)text).substring(0, ((String)text).length() - 1);
                }
                text = (String)text + "...";
            }
            int color = this.enchantment.is(EnchantmentTags.CURSE) ? 16536660 : 0xFFFFFF;
            font.drawInBatch((String)text, (float)(this.x1 + 4), (float)(this.y1 + 4), color, false, this.gui.pose().last().pose(), (MultiBufferSource)this.gui.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    static enum Status {
        UNHOVERED,
        HOVERED,
        SELECTED;

    }
}

