/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.network.experience_obelisk;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateContents
implements CustomPacketPayload {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int levels;
    public final String request;
    public static final String FILL = "FILL";
    public static final String FILL_ALL = "FILL_ALL";
    public static final String DRAIN = "DRAIN";
    public static final String DRAIN_ALL = "DRAIN_ALL";
    public static final StreamCodec<ByteBuf, UpdateContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdateContents::getPosX, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateContents::getPosY, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateContents::getPosZ, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateContents::getLevels, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateContents::getRequest, UpdateContents::new);
    public static final CustomPacketPayload.Type<UpdateContents> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"experience_obelisk_update_contents"));

    public UpdateContents(BlockPos pos, int levels, String request) {
        this.posX = pos.getX();
        this.posY = pos.getY();
        this.posZ = pos.getZ();
        this.levels = levels;
        this.request = request;
    }

    public UpdateContents(int posX, int posY, int posZ, int levels, String request) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.levels = levels;
        this.request = request;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public int getLevels() {
        return this.levels;
    }

    public String getRequest() {
        return this.request;
    }

    public static void handle(UpdateContents packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            BlockEntity entity = player.level().getBlockEntity(new BlockPos(packet.posX, packet.posY, packet.posZ));
            if (entity instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)entity;
                obelisk.handleRequest(packet.request, packet.levels, player);
            }
        });
    }
}

