/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe;

import com.cyanogen.cognition.registries.RegisterRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class FillingRecipe
implements Recipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final int mBcost;
    private final ResourceLocation id;

    public FillingRecipe(Ingredient ingredient, ItemStack result, int mBcost, ResourceLocation id) {
        this.ingredient = ingredient;
        this.result = result;
        this.mBcost = mBcost;
        this.id = id;
    }

    @Nullable
    public static FillingRecipe getRecipe(Level level, ItemStack stack) {
        List recipeList = level.getRecipeManager().getAllRecipesFor((RecipeType)RegisterRecipes.FILLING_TYPE.get());
        FillingRecipe infectingRecipe = null;
        for (RecipeHolder holder : recipeList) {
            if (!((FillingRecipe)holder.value()).matches(stack)) continue;
            infectingRecipe = (FillingRecipe)holder.value();
            break;
        }
        return infectingRecipe;
    }

    public boolean matches(final ItemStack stack) {
        return this.matches(new RecipeInput(){

            public ItemStack getItem(int i) {
                return stack;
            }

            public int size() {
                return 1;
            }
        }, null);
    }

    public boolean matches(RecipeInput recipeInput, @Nullable Level level) {
        return this.ingredient.test(recipeInput.getItem(0));
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCognitiumCost() {
        return this.mBcost;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FillingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"filling");
        private static final MapCodec<FillingRecipe> CODEC = RecordCodecBuilder.mapCodec(recipeInstance -> recipeInstance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("cost_mB").forGetter(recipe -> recipe.mBcost), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(recipe -> recipe.id)).apply((Applicative)recipeInstance, FillingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FillingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static FillingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int mBcost = buffer.readInt();
            ResourceLocation id = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new FillingRecipe(ingredient, result, mBcost, id);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, FillingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.mBcost);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.id);
        }

        public MapCodec<FillingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FillingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<FillingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "filling";
    }
}

